/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import org.reactivestreams.Publisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.repository.query.ConvertingParameterAccessor;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParameterAccessor;
import org.springframework.data.elasticsearch.repository.query.ReactiveElasticsearchParametersParameterAccessor;
import org.springframework.data.elasticsearch.repository.query.ReactiveElasticsearchQueryExecution;
import org.springframework.data.elasticsearch.repository.query.ReactiveElasticsearchQueryMethod;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class AbstractReactiveElasticsearchRepositoryQuery
implements RepositoryQuery {
    private final ReactiveElasticsearchQueryMethod queryMethod;
    private final ReactiveElasticsearchOperations elasticsearchOperations;

    AbstractReactiveElasticsearchRepositoryQuery(ReactiveElasticsearchQueryMethod queryMethod, ReactiveElasticsearchOperations elasticsearchOperations) {
        this.queryMethod = queryMethod;
        this.elasticsearchOperations = elasticsearchOperations;
    }

    public Object execute(Object[] parameters) {
        return this.queryMethod.hasReactiveWrapperParameter() ? this.executeDeferred(parameters) : this.execute(new ReactiveElasticsearchParametersParameterAccessor(this.queryMethod, parameters));
    }

    private Object executeDeferred(Object[] parameters) {
        ReactiveElasticsearchParametersParameterAccessor parameterAccessor = new ReactiveElasticsearchParametersParameterAccessor(this.queryMethod, parameters);
        if (this.getQueryMethod().isCollectionQuery()) {
            return Flux.defer(() -> (Publisher)this.execute(parameterAccessor));
        }
        return Mono.defer(() -> (Mono)this.execute(parameterAccessor));
    }

    private Object execute(ElasticsearchParameterAccessor parameterAccessor) {
        ResultProcessor processor = this.queryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)parameterAccessor);
        Query query = this.createQuery(new ConvertingParameterAccessor(this.elasticsearchOperations.getElasticsearchConverter(), parameterAccessor));
        Class typeToRead = processor.getReturnedType().getTypeToRead();
        String indexName = this.queryMethod.getEntityInformation().getIndexName();
        String indexTypeName = this.queryMethod.getEntityInformation().getIndexTypeName();
        ReactiveElasticsearchQueryExecution execution = this.getExecution(parameterAccessor, new ReactiveElasticsearchQueryExecution.ResultProcessingConverter(processor, this.elasticsearchOperations));
        return execution.execute(query, processor.getReturnedType().getDomainType(), indexName, indexTypeName, typeToRead);
    }

    private ReactiveElasticsearchQueryExecution getExecution(ElasticsearchParameterAccessor accessor, Converter<Object, Object> resultProcessing) {
        return new ReactiveElasticsearchQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(accessor, this.elasticsearchOperations), resultProcessing);
    }

    protected abstract Query createQuery(ElasticsearchParameterAccessor var1);

    private ReactiveElasticsearchQueryExecution getExecutionToWrap(ElasticsearchParameterAccessor accessor, ReactiveElasticsearchOperations operations) {
        if (this.isDeleteQuery()) {
            return (q, t, i, it, tt) -> operations.deleteBy(q, t, i, it);
        }
        if (this.isCountQuery()) {
            return (q, t, i, it, tt) -> operations.count(q, t, i, it);
        }
        if (this.isExistsQuery()) {
            return (q, t, i, it, tt) -> operations.count(q, t, i, it).map(count -> count > 0L);
        }
        if (this.queryMethod.isCollectionQuery()) {
            return (q, t, i, it, tt) -> operations.find((Query)q.setPageable(accessor.getPageable()), t, i, it, tt);
        }
        return (q, t, i, it, tt) -> operations.find(q, t, i, it, tt);
    }

    abstract boolean isDeleteQuery();

    abstract boolean isCountQuery();

    abstract boolean isExistsQuery();

    abstract boolean isLimiting();

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected ReactiveElasticsearchOperations getElasticsearchOperations() {
        return this.elasticsearchOperations;
    }

    protected MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> getMappingContext() {
        return this.elasticsearchOperations.getElasticsearchConverter().getMappingContext();
    }
}

