/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.aggregation.impl;

import java.util.List;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.FacetedPageImpl;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;

public class AggregatedPageImpl<T>
extends FacetedPageImpl<T>
implements AggregatedPage<T> {
    private Aggregations aggregations;
    private String scrollId;
    private float maxScore;

    public AggregatedPageImpl(List<T> content) {
        super(content);
    }

    public AggregatedPageImpl(List<T> content, float maxScore) {
        super(content);
        this.maxScore = maxScore;
    }

    public AggregatedPageImpl(List<T> content, String scrollId) {
        super(content);
        this.scrollId = scrollId;
    }

    public AggregatedPageImpl(List<T> content, String scrollId, float maxScore) {
        this(content, scrollId);
        this.maxScore = maxScore;
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total) {
        super(content, pageable, total);
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total, float maxScore) {
        super(content, pageable, total);
        this.maxScore = maxScore;
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total, String scrollId) {
        super(content, pageable, total);
        this.scrollId = scrollId;
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total, String scrollId, float maxScore) {
        this(content, pageable, total, scrollId);
        this.maxScore = maxScore;
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total, Aggregations aggregations) {
        super(content, pageable, total);
        this.aggregations = aggregations;
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total, Aggregations aggregations, float maxScore) {
        this(content, pageable, total, aggregations);
        this.maxScore = maxScore;
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total, Aggregations aggregations, String scrollId) {
        this(content, pageable, total, aggregations);
        this.scrollId = scrollId;
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total, Aggregations aggregations, String scrollId, float maxScore) {
        this(content, pageable, total, aggregations, scrollId);
        this.maxScore = maxScore;
    }

    @Override
    public boolean hasAggregations() {
        return this.aggregations != null;
    }

    @Override
    public Aggregations getAggregations() {
        return this.aggregations;
    }

    @Override
    public Aggregation getAggregation(String name) {
        return this.aggregations == null ? null : this.aggregations.get(name);
    }

    @Override
    public String getScrollId() {
        return this.scrollId;
    }

    @Override
    public float getMaxScore() {
        return this.maxScore;
    }
}

