/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.util.Properties;
import java.util.function.BiConsumer;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.elasticsearch.client.ClusterNodes;

public class TransportClientFactoryBean
implements FactoryBean<TransportClient>,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(TransportClientFactoryBean.class);
    private ClusterNodes clusterNodes = ClusterNodes.of("127.0.0.1:9300");
    private String clusterName = "elasticsearch";
    private Boolean clientTransportSniff = true;
    private Boolean clientIgnoreClusterName = Boolean.FALSE;
    private String clientPingTimeout = "5s";
    private String clientNodesSamplerInterval = "5s";
    private TransportClient client;
    private Properties properties;

    public void destroy() throws Exception {
        try {
            logger.info("Closing elasticSearch  client");
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            logger.error("Error closing ElasticSearch client: ", (Throwable)e);
        }
    }

    public TransportClient getObject() throws Exception {
        return this.client;
    }

    public Class<TransportClient> getObjectType() {
        return TransportClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.buildClient();
    }

    protected void buildClient() throws Exception {
        this.client = new PreBuiltTransportClient(this.settings(), new Class[0]);
        this.clusterNodes.stream().peek(it -> logger.info("Adding transport node : " + it.toString())).forEach(arg_0 -> ((TransportClient)this.client).addTransportAddress(arg_0));
        this.client.connectedNodes();
    }

    private Settings settings() {
        if (this.properties != null) {
            Settings.Builder builder = Settings.builder();
            this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> builder.put(key.toString(), value.toString())));
            return builder.build();
        }
        return Settings.builder().put("cluster.name", this.clusterName).put("client.transport.sniff", this.clientTransportSniff.booleanValue()).put("client.transport.ignore_cluster_name", this.clientIgnoreClusterName.booleanValue()).put("client.transport.ping_timeout", this.clientPingTimeout).put("client.transport.nodes_sampler_interval", this.clientNodesSamplerInterval).build();
    }

    public void setClusterNodes(String clusterNodes) {
        this.clusterNodes = ClusterNodes.of(clusterNodes);
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setClientTransportSniff(Boolean clientTransportSniff) {
        this.clientTransportSniff = clientTransportSniff;
    }

    public String getClientNodesSamplerInterval() {
        return this.clientNodesSamplerInterval;
    }

    public void setClientNodesSamplerInterval(String clientNodesSamplerInterval) {
        this.clientNodesSamplerInterval = clientNodesSamplerInterval;
    }

    public String getClientPingTimeout() {
        return this.clientPingTimeout;
    }

    public void setClientPingTimeout(String clientPingTimeout) {
        this.clientPingTimeout = clientPingTimeout;
    }

    public Boolean getClientIgnoreClusterName() {
        return this.clientIgnoreClusterName;
    }

    public void setClientIgnoreClusterName(Boolean clientIgnoreClusterName) {
        this.clientIgnoreClusterName = clientIgnoreClusterName;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

