/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.annotation.Transient;
import org.springframework.data.elasticsearch.annotations.CompletionContext;
import org.springframework.data.elasticsearch.annotations.CompletionField;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.DynamicTemplates;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.GeoPointField;
import org.springframework.data.elasticsearch.annotations.InnerField;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.annotations.MultiField;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.completion.Completion;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.util.StringUtils;

class MappingBuilder {
    public static final String FIELD_DATA = "fielddata";
    public static final String FIELD_STORE = "store";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_INDEX = "index";
    public static final String FIELD_FORMAT = "format";
    public static final String FIELD_SEARCH_ANALYZER = "search_analyzer";
    public static final String FIELD_INDEX_ANALYZER = "analyzer";
    public static final String FIELD_NORMALIZER = "normalizer";
    public static final String FIELD_PROPERTIES = "properties";
    public static final String FIELD_PARENT = "_parent";
    public static final String FIELD_COPY_TO = "copy_to";
    public static final String FIELD_CONTEXT_NAME = "name";
    public static final String FIELD_CONTEXT_TYPE = "type";
    public static final String FIELD_CONTEXT_PRECISION = "precision";
    public static final String FIELD_DYNAMIC_TEMPLATES = "dynamic_templates";
    public static final String COMPLETION_PRESERVE_SEPARATORS = "preserve_separators";
    public static final String COMPLETION_PRESERVE_POSITION_INCREMENTS = "preserve_position_increments";
    public static final String COMPLETION_MAX_INPUT_LENGTH = "max_input_length";
    public static final String COMPLETION_CONTEXTS = "contexts";
    public static final String TYPE_VALUE_KEYWORD = "keyword";
    public static final String TYPE_VALUE_GEO_POINT = "geo_point";
    public static final String TYPE_VALUE_COMPLETION = "completion";
    public static final String TYPE_VALUE_GEO_HASH_PREFIX = "geohash_prefix";
    public static final String TYPE_VALUE_GEO_HASH_PRECISION = "geohash_precision";
    private static SimpleTypeHolder SIMPLE_TYPE_HOLDER = SimpleTypeHolder.DEFAULT;

    MappingBuilder() {
    }

    static XContentBuilder buildMapping(Class<?> clazz, String indexType, String idFieldName, String parentType) throws IOException {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject(indexType);
        MappingBuilder.addDynamicTemplatesMapping(mapping, clazz);
        if (StringUtils.hasText((String)parentType)) {
            mapping.startObject(FIELD_PARENT).field("type", parentType).endObject();
        }
        XContentBuilder xContentBuilder = mapping.startObject(FIELD_PROPERTIES);
        MappingBuilder.mapEntity(xContentBuilder, clazz, true, idFieldName, "", false, FieldType.Auto, null);
        return xContentBuilder.endObject().endObject().endObject();
    }

    private static void mapEntity(XContentBuilder xContentBuilder, Class<?> clazz, boolean isRootObject, String idFieldName, String nestedObjectFieldName, boolean nestedOrObjectField, FieldType fieldType, org.springframework.data.elasticsearch.annotations.Field fieldAnnotation) throws IOException {
        Field[] fields = MappingBuilder.retrieveFields(clazz);
        if (!isRootObject && (MappingBuilder.isAnyPropertyAnnotatedAsField(fields) || nestedOrObjectField)) {
            String type = FieldType.Object.toString().toLowerCase();
            if (nestedOrObjectField) {
                type = fieldType.toString().toLowerCase();
            }
            XContentBuilder t = xContentBuilder.startObject(nestedObjectFieldName).field("type", type);
            if (nestedOrObjectField && FieldType.Nested == fieldType && fieldAnnotation.includeInParent()) {
                t.field("include_in_parent", fieldAnnotation.includeInParent());
            }
            t.startObject(FIELD_PROPERTIES);
        }
        for (Field field : fields) {
            ClassPathResource mappings;
            String mappingPath;
            if (field.isAnnotationPresent(Transient.class) || MappingBuilder.isInIgnoreFields(field, fieldAnnotation)) continue;
            if (field.isAnnotationPresent(Mapping.class) && !StringUtils.isEmpty((Object)(mappingPath = field.getAnnotation(Mapping.class).mappingPath())) && (mappings = new ClassPathResource(mappingPath)).exists()) {
                xContentBuilder.rawField(field.getName(), mappings.getInputStream(), XContentType.JSON);
                continue;
            }
            boolean isGeoPointField = MappingBuilder.isGeoPointField(field);
            boolean isCompletionField = MappingBuilder.isCompletionField(field);
            org.springframework.data.elasticsearch.annotations.Field singleField = field.getAnnotation(org.springframework.data.elasticsearch.annotations.Field.class);
            if (!isGeoPointField && !isCompletionField && MappingBuilder.isEntity(field) && MappingBuilder.isAnnotated(field)) {
                if (singleField == null) continue;
                boolean nestedOrObject = MappingBuilder.isNestedOrObjectField(field);
                MappingBuilder.mapEntity(xContentBuilder, MappingBuilder.getFieldType(field), false, "", field.getName(), nestedOrObject, singleField.type(), field.getAnnotation(org.springframework.data.elasticsearch.annotations.Field.class));
                if (nestedOrObject) continue;
            }
            MultiField multiField = field.getAnnotation(MultiField.class);
            if (isGeoPointField) {
                MappingBuilder.applyGeoPointFieldMapping(xContentBuilder, field);
            }
            if (isCompletionField) {
                CompletionField completionField = field.getAnnotation(CompletionField.class);
                MappingBuilder.applyCompletionFieldMapping(xContentBuilder, field, completionField);
            }
            if (isRootObject && singleField != null && MappingBuilder.isIdField(field, idFieldName)) {
                MappingBuilder.applyDefaultIdFieldMapping(xContentBuilder, field);
                continue;
            }
            if (multiField != null) {
                MappingBuilder.addMultiFieldMapping(xContentBuilder, field, multiField, MappingBuilder.isNestedOrObjectField(field));
                continue;
            }
            if (singleField == null) continue;
            MappingBuilder.addSingleFieldMapping(xContentBuilder, field, singleField, MappingBuilder.isNestedOrObjectField(field));
        }
        if (!isRootObject && MappingBuilder.isAnyPropertyAnnotatedAsField(fields) || nestedOrObjectField) {
            xContentBuilder.endObject().endObject();
        }
    }

    private static Field[] retrieveFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> targetClass = clazz;
        do {
            fields.addAll(Arrays.asList(targetClass.getDeclaredFields()));
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return fields.toArray(new Field[fields.size()]);
    }

    private static boolean isAnnotated(Field field) {
        return field.getAnnotation(org.springframework.data.elasticsearch.annotations.Field.class) != null || field.getAnnotation(MultiField.class) != null || field.getAnnotation(GeoPointField.class) != null || field.getAnnotation(CompletionField.class) != null;
    }

    private static void applyGeoPointFieldMapping(XContentBuilder xContentBuilder, Field field) throws IOException {
        xContentBuilder.startObject(field.getName());
        xContentBuilder.field("type", TYPE_VALUE_GEO_POINT);
        xContentBuilder.endObject();
    }

    private static void applyCompletionFieldMapping(XContentBuilder xContentBuilder, Field field, CompletionField annotation) throws IOException {
        xContentBuilder.startObject(field.getName());
        xContentBuilder.field("type", TYPE_VALUE_COMPLETION);
        if (annotation != null) {
            xContentBuilder.field(COMPLETION_MAX_INPUT_LENGTH, annotation.maxInputLength());
            xContentBuilder.field(COMPLETION_PRESERVE_POSITION_INCREMENTS, annotation.preservePositionIncrements());
            xContentBuilder.field(COMPLETION_PRESERVE_SEPARATORS, annotation.preserveSeparators());
            if (!StringUtils.isEmpty((Object)annotation.searchAnalyzer())) {
                xContentBuilder.field(FIELD_SEARCH_ANALYZER, annotation.searchAnalyzer());
            }
            if (!StringUtils.isEmpty((Object)annotation.analyzer())) {
                xContentBuilder.field(FIELD_INDEX_ANALYZER, annotation.analyzer());
            }
            if (annotation.contexts().length > 0) {
                xContentBuilder.startArray(COMPLETION_CONTEXTS);
                for (CompletionContext context : annotation.contexts()) {
                    xContentBuilder.startObject();
                    xContentBuilder.field(FIELD_CONTEXT_NAME, context.name());
                    xContentBuilder.field("type", context.type().name().toLowerCase());
                    if (context.precision().length() > 0) {
                        xContentBuilder.field(FIELD_CONTEXT_PRECISION, context.precision());
                    }
                    xContentBuilder.endObject();
                }
                xContentBuilder.endArray();
            }
        }
        xContentBuilder.endObject();
    }

    private static void applyDefaultIdFieldMapping(XContentBuilder xContentBuilder, Field field) throws IOException {
        xContentBuilder.startObject(field.getName()).field("type", TYPE_VALUE_KEYWORD).field(FIELD_INDEX, true);
        xContentBuilder.endObject();
    }

    private static void addSingleFieldMapping(XContentBuilder builder, Field field, org.springframework.data.elasticsearch.annotations.Field annotation, boolean nestedOrObjectField) throws IOException {
        builder.startObject(field.getName());
        MappingBuilder.addFieldMappingParameters(builder, annotation, nestedOrObjectField);
        builder.endObject();
    }

    private static void addMultiFieldMapping(XContentBuilder builder, Field field, MultiField annotation, boolean nestedOrObjectField) throws IOException {
        builder.startObject(field.getName());
        MappingBuilder.addFieldMappingParameters(builder, annotation.mainField(), nestedOrObjectField);
        builder.startObject("fields");
        for (InnerField innerField : annotation.otherFields()) {
            builder.startObject(innerField.suffix());
            MappingBuilder.addFieldMappingParameters(builder, innerField, false);
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
    }

    private static void addFieldMappingParameters(XContentBuilder builder, Object annotation, boolean nestedOrObjectField) throws IOException {
        boolean index = true;
        boolean store = false;
        boolean fielddata = false;
        FieldType type = null;
        DateFormat dateFormat = null;
        String datePattern = null;
        String analyzer = null;
        String searchAnalyzer = null;
        String normalizer = null;
        String[] copyTo = null;
        if (annotation instanceof org.springframework.data.elasticsearch.annotations.Field) {
            org.springframework.data.elasticsearch.annotations.Field fieldAnnotation = (org.springframework.data.elasticsearch.annotations.Field)annotation;
            index = fieldAnnotation.index();
            store = fieldAnnotation.store();
            fielddata = fieldAnnotation.fielddata();
            type = fieldAnnotation.type();
            dateFormat = fieldAnnotation.format();
            datePattern = fieldAnnotation.pattern();
            analyzer = fieldAnnotation.analyzer();
            searchAnalyzer = fieldAnnotation.searchAnalyzer();
            normalizer = fieldAnnotation.normalizer();
            copyTo = fieldAnnotation.copyTo();
        } else if (annotation instanceof InnerField) {
            InnerField fieldAnnotation = (InnerField)annotation;
            index = fieldAnnotation.index();
            store = fieldAnnotation.store();
            fielddata = fieldAnnotation.fielddata();
            type = fieldAnnotation.type();
            dateFormat = fieldAnnotation.format();
            datePattern = fieldAnnotation.pattern();
            analyzer = fieldAnnotation.analyzer();
            searchAnalyzer = fieldAnnotation.searchAnalyzer();
            normalizer = fieldAnnotation.normalizer();
        } else {
            throw new IllegalArgumentException("annotation must be an instance of @Field or @InnerField");
        }
        if (!nestedOrObjectField) {
            builder.field(FIELD_STORE, store);
        }
        if (fielddata) {
            builder.field(FIELD_DATA, fielddata);
        }
        if (type != FieldType.Auto) {
            builder.field("type", type.name().toLowerCase());
            if (type == FieldType.Date && dateFormat != DateFormat.none) {
                builder.field(FIELD_FORMAT, dateFormat == DateFormat.custom ? datePattern : dateFormat.toString());
            }
        }
        if (!index) {
            builder.field(FIELD_INDEX, index);
        }
        if (!StringUtils.isEmpty((Object)analyzer)) {
            builder.field(FIELD_INDEX_ANALYZER, analyzer);
        }
        if (!StringUtils.isEmpty((Object)searchAnalyzer)) {
            builder.field(FIELD_SEARCH_ANALYZER, searchAnalyzer);
        }
        if (!StringUtils.isEmpty((Object)normalizer)) {
            builder.field(FIELD_NORMALIZER, normalizer);
        }
        if (copyTo != null && copyTo.length > 0) {
            builder.field(FIELD_COPY_TO, (Object)copyTo);
        }
    }

    private static void addDynamicTemplatesMapping(XContentBuilder builder, Class<?> clazz) throws IOException {
        ObjectMapper objectMapper;
        JsonNode jsonNode;
        String jsonString;
        String mappingPath;
        if (clazz.isAnnotationPresent(DynamicTemplates.class) && StringUtils.hasText((String)(mappingPath = clazz.getAnnotation(DynamicTemplates.class).mappingPath())) && StringUtils.hasText((String)(jsonString = ElasticsearchTemplate.readFileFromClasspath(mappingPath))) && (jsonNode = (objectMapper = new ObjectMapper()).readTree(jsonString).get(FIELD_DYNAMIC_TEMPLATES)) != null && jsonNode.isArray()) {
            String json = objectMapper.writeValueAsString((Object)jsonNode);
            builder.rawField(FIELD_DYNAMIC_TEMPLATES, (InputStream)new ByteArrayInputStream(json.getBytes()), XContentType.JSON);
        }
    }

    protected static boolean isEntity(Field field) {
        ClassTypeInformation typeInformation = ClassTypeInformation.from(field.getType());
        Class<?> clazz = MappingBuilder.getFieldType(field);
        boolean isComplexType = !SIMPLE_TYPE_HOLDER.isSimpleType(clazz);
        return isComplexType && !Map.class.isAssignableFrom(typeInformation.getType());
    }

    protected static Class<?> getFieldType(Field field) {
        ResolvableType resolvableType = ResolvableType.forField((Field)field);
        if (resolvableType.isArray()) {
            return resolvableType.getComponentType().getRawClass();
        }
        ResolvableType componentType = resolvableType.getGeneric(new int[]{0});
        if (Iterable.class.isAssignableFrom(field.getType()) && componentType != ResolvableType.NONE) {
            return componentType.getRawClass();
        }
        return resolvableType.getRawClass();
    }

    private static boolean isAnyPropertyAnnotatedAsField(Field[] fields) {
        if (fields != null) {
            for (Field field : fields) {
                if (!field.isAnnotationPresent(org.springframework.data.elasticsearch.annotations.Field.class)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isIdField(Field field, String idFieldName) {
        return idFieldName.equals(field.getName());
    }

    private static boolean isInIgnoreFields(Field field, org.springframework.data.elasticsearch.annotations.Field parentFieldAnnotation) {
        if (null != parentFieldAnnotation) {
            String[] ignoreFields = parentFieldAnnotation.ignoreFields();
            return Arrays.asList(ignoreFields).contains(field.getName());
        }
        return false;
    }

    private static boolean isNestedOrObjectField(Field field) {
        org.springframework.data.elasticsearch.annotations.Field fieldAnnotation = field.getAnnotation(org.springframework.data.elasticsearch.annotations.Field.class);
        return fieldAnnotation != null && (FieldType.Nested == fieldAnnotation.type() || FieldType.Object == fieldAnnotation.type());
    }

    private static boolean isGeoPointField(Field field) {
        return field.getType() == GeoPoint.class || field.getAnnotation(GeoPointField.class) != null;
    }

    private static boolean isCompletionField(Field field) {
        return field.getType() == Completion.class;
    }
}

