/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.lucene.queryparser.flexible.core.util.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.util.Assert;

class CriteriaQueryProcessor {
    CriteriaQueryProcessor() {
    }

    QueryBuilder createQueryFromCriteria(Criteria criteria) {
        if (criteria == null) {
            return null;
        }
        LinkedList<QueryBuilder> shouldQueryBuilderList = new LinkedList<QueryBuilder>();
        LinkedList<QueryBuilder> mustNotQueryBuilderList = new LinkedList<QueryBuilder>();
        LinkedList<QueryBuilder> mustQueryBuilderList = new LinkedList<QueryBuilder>();
        ListIterator<Criteria> chainIterator = criteria.getCriteriaChain().listIterator();
        QueryBuilder firstQuery = null;
        boolean negateFirstQuery = false;
        while (chainIterator.hasNext()) {
            Criteria chainedCriteria = chainIterator.next();
            QueryBuilder queryFragmentForCriteria = this.createQueryFragmentForCriteria(chainedCriteria);
            if (queryFragmentForCriteria == null) continue;
            if (firstQuery == null) {
                firstQuery = queryFragmentForCriteria;
                negateFirstQuery = chainedCriteria.isNegating();
                continue;
            }
            if (chainedCriteria.isOr()) {
                shouldQueryBuilderList.add(queryFragmentForCriteria);
                continue;
            }
            if (chainedCriteria.isNegating()) {
                mustNotQueryBuilderList.add(queryFragmentForCriteria);
                continue;
            }
            mustQueryBuilderList.add(queryFragmentForCriteria);
        }
        if (firstQuery != null) {
            if (!shouldQueryBuilderList.isEmpty() && mustNotQueryBuilderList.isEmpty() && mustQueryBuilderList.isEmpty()) {
                shouldQueryBuilderList.add(0, firstQuery);
            } else if (negateFirstQuery) {
                mustNotQueryBuilderList.add(0, firstQuery);
            } else {
                mustQueryBuilderList.add(0, firstQuery);
            }
        }
        BoolQueryBuilder query = null;
        if (!(shouldQueryBuilderList.isEmpty() && mustNotQueryBuilderList.isEmpty() && mustQueryBuilderList.isEmpty())) {
            query = QueryBuilders.boolQuery();
            for (QueryBuilder qb : shouldQueryBuilderList) {
                query.should(qb);
            }
            for (QueryBuilder qb : mustNotQueryBuilderList) {
                query.mustNot(qb);
            }
            for (QueryBuilder qb : mustQueryBuilderList) {
                query.must(qb);
            }
        }
        return query;
    }

    private QueryBuilder createQueryFragmentForCriteria(Criteria chainedCriteria) {
        if (chainedCriteria.getQueryCriteriaEntries().isEmpty()) {
            return null;
        }
        Iterator<Criteria.CriteriaEntry> it = chainedCriteria.getQueryCriteriaEntries().iterator();
        boolean singeEntryCriteria = chainedCriteria.getQueryCriteriaEntries().size() == 1;
        String fieldName = chainedCriteria.getField().getName();
        Assert.notNull((Object)fieldName, (String)"Unknown field");
        BoolQueryBuilder query = null;
        if (singeEntryCriteria) {
            Criteria.CriteriaEntry entry = it.next();
            query = this.processCriteriaEntry(entry, fieldName);
        } else {
            query = QueryBuilders.boolQuery();
            while (it.hasNext()) {
                Criteria.CriteriaEntry entry = it.next();
                query.must(this.processCriteriaEntry(entry, fieldName));
            }
        }
        this.addBoost((QueryBuilder)query, chainedCriteria.getBoost());
        return query;
    }

    private QueryBuilder processCriteriaEntry(Criteria.CriteriaEntry entry, String fieldName) {
        Object value = entry.getValue();
        if (value == null) {
            return null;
        }
        Criteria.OperationKey key = entry.getKey();
        BoolQueryBuilder query = null;
        String searchText = StringUtils.toString((Object)value);
        Iterable collection = null;
        switch (key) {
            case EQUALS: {
                query = QueryBuilders.queryString((String)searchText).field(fieldName).defaultOperator(QueryStringQueryBuilder.Operator.AND);
                break;
            }
            case CONTAINS: {
                query = QueryBuilders.queryString((String)("*" + searchText + "*")).field(fieldName).analyzeWildcard(true);
                break;
            }
            case STARTS_WITH: {
                query = QueryBuilders.queryString((String)(searchText + "*")).field(fieldName).analyzeWildcard(true);
                break;
            }
            case ENDS_WITH: {
                query = QueryBuilders.queryString((String)("*" + searchText)).field(fieldName).analyzeWildcard(true);
                break;
            }
            case EXPRESSION: {
                query = QueryBuilders.queryString((String)searchText).field(fieldName);
                break;
            }
            case LESS_EQUAL: {
                query = QueryBuilders.rangeQuery((String)fieldName).lte(value);
                break;
            }
            case GREATER_EQUAL: {
                query = QueryBuilders.rangeQuery((String)fieldName).gte(value);
                break;
            }
            case BETWEEN: {
                Object[] ranges = (Object[])value;
                query = QueryBuilders.rangeQuery((String)fieldName).from(ranges[0]).to(ranges[1]);
                break;
            }
            case LESS: {
                query = QueryBuilders.rangeQuery((String)fieldName).lt(value);
                break;
            }
            case GREATER: {
                query = QueryBuilders.rangeQuery((String)fieldName).gt(value);
                break;
            }
            case FUZZY: {
                query = QueryBuilders.fuzzyQuery((String)fieldName, (String)searchText);
                break;
            }
            case IN: {
                query = QueryBuilders.boolQuery();
                collection = (Iterable)value;
                for (Object item : collection) {
                    query.should((QueryBuilder)QueryBuilders.queryString((String)item.toString()).field(fieldName));
                }
                break;
            }
            case NOT_IN: {
                query = QueryBuilders.boolQuery();
                collection = (Iterable)value;
                for (Object item : collection) {
                    query.mustNot((QueryBuilder)QueryBuilders.queryString((String)item.toString()).field(fieldName));
                }
                break;
            }
        }
        return query;
    }

    private void addBoost(QueryBuilder query, float boost) {
        if (Float.isNaN(boost)) {
            return;
        }
        if (query instanceof BoostableQueryBuilder) {
            ((BoostableQueryBuilder)query).boost(boost);
        }
    }
}

