/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.transaction;

import com.couchbase.client.core.annotation.Stability;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.data.couchbase.transaction.CouchbaseCallbackTransactionManager;
import org.springframework.lang.Nullable;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Stability.Internal
public class CouchbaseTransactionInterceptor
extends TransactionInterceptor
implements MethodInterceptor,
Serializable {
    public CouchbaseTransactionInterceptor(TransactionManager ptm, TransactionAttributeSource tas) {
        super(ptm, tas);
    }

    @Nullable
    protected Object invokeWithinTransaction(Method method, @Nullable Class<?> targetClass, TransactionAspectSupport.InvocationCallback invocation) throws Throwable {
        TransactionAttribute txAttr;
        TransactionAttributeSource tas = this.getTransactionAttributeSource();
        TransactionAttribute transactionAttribute = txAttr = tas != null ? tas.getTransactionAttribute(method, targetClass) : null;
        if (this.getTransactionManager() instanceof CouchbaseCallbackTransactionManager) {
            CouchbaseCallbackTransactionManager manager = (CouchbaseCallbackTransactionManager)this.getTransactionManager();
            if (Mono.class.isAssignableFrom(method.getReturnType())) {
                return manager.executeReactive((TransactionDefinition)txAttr, ignored -> {
                    try {
                        return (Mono)invocation.proceedWithInvocation();
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }).singleOrEmpty();
            }
            if (Flux.class.isAssignableFrom(method.getReturnType())) {
                return manager.executeReactive((TransactionDefinition)txAttr, ignored -> {
                    try {
                        return (Flux)invocation.proceedWithInvocation();
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            return manager.execute((TransactionDefinition)txAttr, ignored -> {
                try {
                    return invocation.proceedWithInvocation();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return super.invokeWithinTransaction(method, targetClass, invocation);
    }
}

