/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.query;

import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.json.JsonValue;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.core.query.QueryCriteriaDefinition;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class QueryCriteria
implements QueryCriteriaDefinition {
    private N1QLExpression key;
    private LinkedList<QueryCriteria> criteriaChain;
    private ChainOperator chainOperator;
    private String operator;
    private Object[] value;
    private String format;

    public QueryCriteria(LinkedList<QueryCriteria> chain, N1QLExpression key, Object[] value, ChainOperator chainOperator) {
        this(chain, key, value, chainOperator, null, null);
    }

    QueryCriteria(LinkedList<QueryCriteria> chain, N1QLExpression key, Object value, ChainOperator chainOperator) {
        this(chain, key, new Object[]{value}, chainOperator, null, null);
    }

    QueryCriteria(LinkedList<QueryCriteria> chain, N1QLExpression key, Object[] value, ChainOperator chainOperator, String operator, String format) {
        this.criteriaChain = chain != null ? chain : new LinkedList();
        this.chainOperator = chainOperator;
        this.criteriaChain.add(this);
        this.key = key;
        this.value = value;
        this.operator = operator;
        this.format = format;
    }

    public static QueryCriteria where(String key) {
        return QueryCriteria.where(N1QLExpression.x(key));
    }

    public static QueryCriteria where(N1QLExpression key) {
        return new QueryCriteria(null, key, null, null);
    }

    private void replaceThisAsWrapperOf(QueryCriteria criteria) {
        QueryCriteria qc = new QueryCriteria(criteria.criteriaChain, criteria.key, criteria.value, criteria.chainOperator, criteria.operator, criteria.format);
        this.criteriaChain.remove(criteria);
        this.criteriaChain = new LinkedList();
        this.criteriaChain.add(this);
        this.key = N1QLExpression.WRAPPER();
        this.operator = "";
        this.value = new Object[]{qc};
        this.chainOperator = null;
    }

    private void wrapThis() {
        QueryCriteria qc = new QueryCriteria(this.criteriaChain, this.key, this.value, this.chainOperator, this.operator, this.format);
        this.criteriaChain.remove(this);
        this.criteriaChain = new LinkedList();
        this.criteriaChain.add(this);
        this.key = N1QLExpression.WRAPPER();
        this.operator = "";
        this.format = null;
        this.value = new Object[]{qc};
        this.chainOperator = null;
    }

    private static QueryCriteria wrap(QueryCriteria criteria) {
        QueryCriteria qc = new QueryCriteria(criteria.criteriaChain, criteria.key, criteria.value, criteria.chainOperator, criteria.operator, criteria.format);
        criteria.criteriaChain.remove(qc);
        int idx = criteria.criteriaChain.indexOf(criteria);
        criteria.criteriaChain.add(idx, qc);
        criteria.criteriaChain.remove(criteria);
        criteria.criteriaChain = new LinkedList();
        criteria.criteriaChain.add(criteria);
        criteria.key = N1QLExpression.WRAPPER();
        criteria.operator = "";
        criteria.format = null;
        criteria.value = new Object[]{qc};
        criteria.chainOperator = null;
        return criteria;
    }

    public QueryCriteria and(String key) {
        return this.and(N1QLExpression.x(key));
    }

    public QueryCriteria and(N1QLExpression key) {
        return new QueryCriteria(this.criteriaChain, key, null, ChainOperator.AND);
    }

    public QueryCriteria and(QueryCriteria criteria) {
        this.checkAndAddToCriteriaChain();
        QueryCriteria newThis = QueryCriteria.wrap(this);
        QueryCriteria qc = QueryCriteria.wrap(criteria);
        newThis.criteriaChain.add(qc);
        qc.setChainOperator(ChainOperator.AND);
        newThis.chainOperator = ChainOperator.AND;
        return newThis;
    }

    public QueryCriteria upper() {
        this.key = N1QLExpression.x("UPPER(" + this.key + ")");
        this.operator = "UPPER";
        this.value = new Object[0];
        return this;
    }

    public QueryCriteria lower() {
        this.key = N1QLExpression.x("LOWER(" + this.key + ")");
        this.operator = "LOWER";
        this.value = new Object[0];
        return this;
    }

    public QueryCriteria or(String key) {
        return this.or(N1QLExpression.x(key));
    }

    public QueryCriteria or(N1QLExpression key) {
        return new QueryCriteria(this.criteriaChain, key, null, ChainOperator.OR);
    }

    public QueryCriteria or(QueryCriteria criteria) {
        this.checkAndAddToCriteriaChain();
        QueryCriteria newThis = QueryCriteria.wrap(this);
        QueryCriteria qc = QueryCriteria.wrap(criteria);
        qc.criteriaChain = newThis.criteriaChain;
        newThis.criteriaChain.add(qc);
        qc.setChainOperator(ChainOperator.OR);
        newThis.chainOperator = ChainOperator.OR;
        return newThis;
    }

    public QueryCriteria eq(@Nullable Object o) {
        return this.eq(false, o);
    }

    public QueryCriteria eq(boolean ignoreCase, @Nullable Object o) {
        return this.is(ignoreCase, o);
    }

    public QueryCriteria is(@Nullable Object o) {
        return this.is(false, o);
    }

    public QueryCriteria is(boolean ignoreCase, @Nullable Object o) {
        this.operator = "=";
        this.format = ignoreCase ? "lower(%1$s) %2$s %3$s" : "%1$s %2$s %3$s";
        this.value = new Object[]{ignoreCase ? o.toString().toLowerCase(Locale.ROOT) : o};
        return this;
    }

    public QueryCriteria ne(@Nullable Object o) {
        return this.ne(false, o);
    }

    public QueryCriteria ne(boolean ignoreCase, @Nullable Object o) {
        this.operator = "!=";
        this.format = ignoreCase ? "lower(%1$s) %2$s %3$s" : "%1$s %2$s %3$s";
        this.value = new Object[]{ignoreCase ? o.toString().toLowerCase(Locale.ROOT) : o};
        return this;
    }

    public QueryCriteria lt(@Nullable Object o) {
        return this.lt(false, o);
    }

    public QueryCriteria lt(boolean ignoreCase, @Nullable Object o) {
        this.operator = "<";
        this.format = ignoreCase ? "lower(%1$s) %2$s %3$s" : "%1$s %2$s %3$s";
        this.value = new Object[]{ignoreCase ? o.toString().toLowerCase(Locale.ROOT) : o};
        return this;
    }

    public QueryCriteria lte(@Nullable Object o) {
        return this.lte(false, o);
    }

    public QueryCriteria lte(boolean ignoreCase, @Nullable Object o) {
        this.operator = "<=";
        this.format = ignoreCase ? "lower(%1$s) %2$s %3$s" : "%1$s %2$s %3$s";
        this.value = new Object[]{ignoreCase ? o.toString().toLowerCase(Locale.ROOT) : o};
        return this;
    }

    public QueryCriteria gt(@Nullable Object o) {
        return this.gt(false, o);
    }

    public QueryCriteria gt(boolean ignoreCase, @Nullable Object o) {
        this.operator = ">";
        this.format = ignoreCase ? "lower(%1$s) %2$s %3$s" : "%1$s %2$s %3$s";
        this.value = new Object[]{ignoreCase ? o.toString().toLowerCase(Locale.ROOT) : o};
        return this;
    }

    public QueryCriteria gte(@Nullable Object o) {
        return this.gte(false, o);
    }

    public QueryCriteria gte(boolean ignoreCase, @Nullable Object o) {
        this.operator = ">=";
        this.format = ignoreCase ? "lower(%1$s) %2$s %3$s" : "%1$s %2$s %3$s";
        this.value = new Object[]{ignoreCase ? o.toString().toLowerCase(Locale.ROOT) : o};
        return this;
    }

    public QueryCriteria startingWith(@Nullable Object o) {
        return this.startingWith(false, o);
    }

    public QueryCriteria startingWith(boolean ignoreCase, @Nullable Object o) {
        this.operator = "like";
        this.value = new Object[]{ignoreCase ? o.toString().toLowerCase(Locale.ROOT) : o};
        this.format = ignoreCase ? "lower(%1$s) %2$s (%3$s||\"%%\")" : "%1$s %2$s (%3$s||\"%%\")";
        return this;
    }

    public QueryCriteria plus(@Nullable Object o) {
        this.operator = "PLUS";
        this.value = new Object[]{o};
        this.format = "(%1$s || %3$s)";
        return this;
    }

    public QueryCriteria endingWith(@Nullable Object o) {
        return this.endingWith(false, o);
    }

    public QueryCriteria endingWith(boolean ignoreCase, @Nullable Object o) {
        this.operator = "like";
        this.value = new Object[]{ignoreCase ? o.toString().toLowerCase(Locale.ROOT) : o};
        this.format = ignoreCase ? "lower(%1$s) %2$s (\"%%\"||%3$s)" : "%1$s %2$s (\"%%\"||%3$s)";
        return this;
    }

    public QueryCriteria regex(@Nullable Object o) {
        this.operator = "REGEXP_LIKE";
        this.value = new Object[]{o};
        this.format = "regexp_like(%1$s, %3$s)";
        return this;
    }

    public QueryCriteria containing(@Nullable Object o) {
        return this.containing(false, o);
    }

    public QueryCriteria containing(boolean ignoreCase, @Nullable Object o) {
        this.operator = "contains";
        this.value = new Object[]{ignoreCase ? o.toString().toLowerCase(Locale.ROOT) : o};
        this.format = ignoreCase ? "%2$s(lower(%1$s), %3$s)" : "%2$s(%1$s, %3$s)";
        return this;
    }

    public QueryCriteria arrayContaining(@Nullable Object o) {
        return this.arrayContaining(false, o);
    }

    public QueryCriteria arrayContaining(boolean ignoreCase, @Nullable Object o) {
        this.operator = "array_contains";
        if (ignoreCase) {
            throw new CouchbaseException("ignoreCase not supported in IN and NOT_IN");
        }
        this.value = new Object[]{o};
        this.format = "array_contains(%1$s, %3$s)";
        return this;
    }

    public QueryCriteria notContaining(@Nullable Object o) {
        return this.notContaining(false, o);
    }

    public QueryCriteria notContaining(boolean ignoreCase, @Nullable Object o) {
        this.replaceThisAsWrapperOf(this.containing(ignoreCase, o));
        this.operator = "not";
        this.format = "%2$s %3$s";
        return this;
    }

    public QueryCriteria negate() {
        this.replaceThisAsWrapperOf(this);
        this.operator = "NOT";
        this.format = "not( %3$s )";
        return this;
    }

    public QueryCriteria size() {
        this.replaceThisAsWrapperOf(this);
        this.operator = "LENGTH";
        this.format = "LENGTH( %3$s )";
        return this;
    }

    public QueryCriteria like(@Nullable Object o) {
        return this.like(false, o);
    }

    public QueryCriteria like(boolean ignoreCase, @Nullable Object o) {
        this.operator = "like";
        this.value = new Object[]{ignoreCase ? o.toString().toLowerCase(Locale.ROOT) : o};
        this.format = ignoreCase ? "lower(%1$s) %2$s %3$s" : "%1$s %2$s %3$s";
        return this;
    }

    public QueryCriteria notLike(@Nullable Object o) {
        return this.notLike(false, o);
    }

    public QueryCriteria notLike(boolean ignoreCase, @Nullable Object o) {
        this.replaceThisAsWrapperOf(this.like(ignoreCase, o));
        this.negate();
        return this;
    }

    public QueryCriteria isNull() {
        this.operator = "IS_NULL";
        this.value = null;
        this.format = "%1$s is null";
        return this;
    }

    public QueryCriteria isNotNull() {
        this.operator = "IS_NOT_NULL";
        this.value = null;
        this.format = "%1$s is not null";
        return this;
    }

    public QueryCriteria isMissing() {
        this.operator = "IS_MISSING";
        this.value = null;
        this.format = "%1$s is missing";
        return this;
    }

    public QueryCriteria isNotMissing() {
        this.operator = "IS_NOT_MiSSING";
        this.value = null;
        this.format = "%1$s is not missing";
        return this;
    }

    public QueryCriteria isValued() {
        this.operator = "IS_VALUED";
        this.value = null;
        this.format = "%1$s is valued";
        return this;
    }

    public QueryCriteria isNotValued() {
        this.operator = "IS_NOT_VALUED";
        this.value = null;
        this.format = "%1$s is not valued";
        return this;
    }

    public QueryCriteria within(boolean ignoreCase, @Nullable Object o) {
        this.operator = "within";
        this.value = new Object[]{ignoreCase ? o.toString().toLowerCase(Locale.ROOT) : o};
        this.format = ignoreCase ? "lower(%1$s) %2$s %3$s" : "%1$s %2$s %3$s";
        return this;
    }

    public QueryCriteria between(@Nullable Object o1, @Nullable Object o2) {
        return this.between(false, o1, o2);
    }

    public QueryCriteria between(boolean ignoreCase, @Nullable Object o1, @Nullable Object o2) {
        this.operator = "BETWEEN";
        this.value = new Object[]{ignoreCase ? o1.toString().toLowerCase(Locale.ROOT) : o1, ignoreCase ? o2.toString().toLowerCase(Locale.ROOT) : o2};
        this.format = ignoreCase ? "lower(%1$s) between %3$s and %4$s" : "%1$s between %3$s and %4$s";
        return this;
    }

    public QueryCriteria in(Object ... o) {
        return this.in(false, o);
    }

    public QueryCriteria in(boolean ignoreCase, Object ... o) {
        this.operator = "in";
        if (ignoreCase) {
            throw new CouchbaseException("ignoreCase not supported in IN and NOT_IN");
        }
        this.format = "%1$s %2$s %3$s";
        this.value = new Object[1];
        if (o.length > 0) {
            if (o[0] instanceof JsonArray || o[0] instanceof List || o[0] instanceof Object[]) {
                if (o.length != 1) {
                    throw new RuntimeException("IN cannot take multiple lists");
                }
                if (o[0] instanceof Object[]) {
                    this.value[0] = o[0];
                } else if (o[0] instanceof JsonArray) {
                    JsonArray ja = (JsonArray)o[0];
                    this.value[0] = ja.toList().toArray();
                } else if (o[0] instanceof List) {
                    List l = (List)o[0];
                    this.value[0] = l.toArray();
                }
            } else if (o instanceof Object[]) {
                this.value[0] = o;
            } else {
                throw new CouchbaseException("unhandled parameters " + o);
            }
        }
        return this;
    }

    public QueryCriteria notIn(Object ... o) {
        return this.in(false, o).negate();
    }

    public QueryCriteria notIn(boolean ignoreCase, Object ... o) {
        return this.in(ignoreCase, o).negate();
    }

    public QueryCriteria TRUE() {
        this.value = null;
        this.operator = null;
        this.format = "%1$s = true";
        return this;
    }

    public QueryCriteria FALSE() {
        this.value = null;
        this.operator = null;
        this.format = "%1$s = false";
        return this;
    }

    @Override
    public String export(int[] paramIndexPtr, JsonValue parameters, CouchbaseConverter converter) {
        StringBuilder output = new StringBuilder();
        boolean first = true;
        for (QueryCriteria c : this.criteriaChain) {
            if (!first) {
                if (c.chainOperator == null) {
                    throw new IllegalStateException("A chain operator must be present when chaining! \n" + c);
                }
                output.append(" ").append(c.chainOperator.representation).append(" ");
            } else {
                first = false;
            }
            c.exportSingle(output, paramIndexPtr, parameters, converter);
        }
        return output.toString();
    }

    @Override
    public String export() {
        return this.export(null, null, null);
    }

    private StringBuilder exportSingle(StringBuilder sb, int[] paramIndexPtr, JsonValue parameters, CouchbaseConverter converter) {
        String fieldName = this.key == null ? null : this.key.toString();
        int valueLen = this.value == null ? 0 : this.value.length;
        Object[] v = new Object[valueLen + 2];
        v[0] = fieldName;
        v[1] = this.operator;
        for (int i = 0; i < valueLen; ++i) {
            v[i + 2] = this.value[i] instanceof QueryCriteria ? "(" + ((QueryCriteria)this.value[i]).export(paramIndexPtr, parameters, converter) + ")" : this.maybeWrapValue(this.key, this.value[i], paramIndexPtr, parameters, converter);
        }
        if (this.key == null) {
            sb.append(v[2]);
        } else if (this.format == null) {
            sb.append(fieldName).append(" ").append(this.operator).append(" ").append(v[2]);
        } else {
            sb.append(new Formatter().format(this.format, v));
        }
        return sb;
    }

    private String maybeWrapValue(N1QLExpression key, Object value, int[] paramIndexPtr, JsonValue parameters, CouchbaseConverter converter) {
        if (paramIndexPtr != null) {
            if (paramIndexPtr[0] >= 0) {
                JsonArray params = (JsonArray)parameters;
                if (value instanceof Object[] || value instanceof Collection) {
                    this.addAsCollection(params, QueryCriteria.asCollection(value), converter);
                } else {
                    params.add(QueryCriteria.convert(converter, value));
                }
                paramIndexPtr[0] = paramIndexPtr[0] + 1;
                return "$" + paramIndexPtr[0];
            }
            JsonObject params = (JsonObject)parameters;
            try {
                params.put(key.toString(), QueryCriteria.convert(converter, value));
            }
            catch (InvalidArgumentException iae) {
                if (value instanceof Object[]) {
                    params.put(key.toString(), JsonArray.from((Object[])((Object[])value)));
                }
                throw iae;
            }
            return "$" + key;
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        if (value == null) {
            return "null";
        }
        if (value instanceof Object[]) {
            StringBuilder l = new StringBuilder();
            l.append("[");
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    l.append(",");
                }
                l.append(this.maybeWrapValue(null, array[i], null, null, converter));
            }
            l.append("]");
            return l.toString();
        }
        return value.toString();
    }

    private static Object convert(CouchbaseConverter converter, Object value) {
        return converter != null ? converter.convertForWriteIfNeeded(value) : value;
    }

    private void addAsCollection(JsonArray posValues, Collection collection, CouchbaseConverter converter) {
        JsonArray ja = JsonValue.ja();
        for (Object e : collection) {
            ja.add(QueryCriteria.convert(converter, e));
        }
        posValues.add(ja);
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    private String maybeBackTic(String value) {
        if (value == null || value.startsWith("`") && value.endsWith("`")) {
            return value;
        }
        return "`" + value + "`";
    }

    @Override
    public void setChainOperator(ChainOperator chainOperator) {
        this.chainOperator = chainOperator;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{key: " + this.key);
        sb.append(", operator: " + this.operator);
        sb.append(", value: " + this.value);
        sb.append(", criteriaChain.size(): " + this.criteriaChain.size() + "\n");
        for (QueryCriteria qc : this.criteriaChain) {
            sb.append("  key: " + qc.key + " operator: " + qc.operator + "\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private void checkAndAddToCriteriaChain() {
        if (this.criteriaChain != null && !this.criteriaChain.contains(this)) {
            throw new RuntimeException("criteria chain does not include this");
        }
        if (this.criteriaChain == null) {
            this.criteriaChain = new LinkedList();
            this.criteriaChain.add(this);
        }
    }

    public static enum ChainOperator {
        AND("and"),
        OR("or");

        private final String representation;

        private ChainOperator(String representation) {
            this.representation = representation;
        }

        public static ChainOperator from(String operator) {
            return ChainOperator.valueOf(operator.substring(1).toUpperCase());
        }

        public String getRepresentation() {
            return this.representation;
        }
    }
}

