/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import org.reactivestreams.Publisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.DtoInstantiatingConverter;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.ReactiveCouchbaseOperations;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ResultProcessingConverter<CouchbaseOperationsType>
implements Converter<Object, Object> {
    private final ResultProcessor processor;
    private final CouchbaseOperationsType operations;
    private final EntityInstantiators instantiators;

    public ResultProcessingConverter(ResultProcessor processor, CouchbaseOperationsType operations, EntityInstantiators instantiators) {
        Assert.notNull((Object)processor, (String)"Processor must not be null!");
        Assert.notNull(operations, (String)"Operations must not be null!");
        Assert.notNull((Object)instantiators, (String)"Instantiators must not be null!");
        this.processor = processor;
        this.operations = operations;
        this.instantiators = instantiators;
    }

    public Object convert(Object source) {
        CouchbaseConverter cvtr;
        ReturnedType returnedType = this.processor.getReturnedType();
        if (ResultProcessingConverter.isVoid(returnedType)) {
            if (source instanceof Mono) {
                return ((Mono)source).then();
            }
            if (source instanceof Publisher) {
                return Flux.from((Publisher)((Publisher)source)).then();
            }
        }
        if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
            return source;
        }
        CouchbaseConverter couchbaseConverter = cvtr = this.operations instanceof CouchbaseOperations ? ((CouchbaseOperations)this.operations).getConverter() : ((ReactiveCouchbaseOperations)this.operations).getConverter();
        if (!cvtr.getMappingContext().hasPersistentEntityFor(returnedType.getReturnedType())) {
            return source;
        }
        DtoInstantiatingConverter converter = new DtoInstantiatingConverter(returnedType.getReturnedType(), cvtr.getMappingContext(), this.instantiators);
        return this.processor.processResult(source, (Converter)converter);
    }

    static boolean isVoid(ReturnedType returnedType) {
        return returnedType.getReturnedType().equals(Void.class);
    }
}

