/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.mapping;

import com.couchbase.client.java.json.JsonObject;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.data.couchbase.core.mapping.CouchbaseList;
import org.springframework.data.couchbase.core.mapping.CouchbaseSimpleTypes;
import org.springframework.data.couchbase.core.mapping.CouchbaseStorable;

public class CouchbaseDocument
implements CouchbaseStorable {
    public static final int DEFAULT_EXPIRATION_TIME = 0;
    private Map<String, Object> content;
    private Object id;
    private int expiration;

    public CouchbaseDocument() {
        this(null);
    }

    public CouchbaseDocument(Object id) {
        this(id, 0);
    }

    public CouchbaseDocument(Object id, int expiration) {
        this.id = id;
        this.expiration = expiration;
        this.content = new TreeMap<String, Object>();
    }

    public final CouchbaseDocument put(String key, Object value) {
        this.verifyValueType(value);
        this.content.put(key, value);
        return this;
    }

    public final Object get(String key) {
        return this.content.get(key);
    }

    public final TreeMap<String, Object> export() {
        TreeMap<String, Object> toExport = new TreeMap<String, Object>(this.content);
        for (Map.Entry<String, Object> entry : this.content.entrySet()) {
            if (entry.getValue() instanceof CouchbaseDocument) {
                toExport.put(entry.getKey(), ((CouchbaseDocument)entry.getValue()).export());
                continue;
            }
            if (!(entry.getValue() instanceof CouchbaseList)) continue;
            toExport.put(entry.getKey(), ((CouchbaseList)entry.getValue()).export());
        }
        return toExport;
    }

    public final boolean containsKey(String key) {
        return this.content.containsKey(key);
    }

    public final boolean containsValue(Object value) {
        return this.content.containsValue(value);
    }

    public final int size() {
        return this.size(false);
    }

    public final int size(boolean recursive) {
        int thisSize = this.content.size();
        if (!recursive || thisSize == 0) {
            return thisSize;
        }
        int totalSize = thisSize;
        for (Object value : this.content.values()) {
            if (value instanceof CouchbaseDocument) {
                totalSize += ((CouchbaseDocument)value).size(true);
                continue;
            }
            if (!(value instanceof CouchbaseList)) continue;
            totalSize += ((CouchbaseList)value).size(true);
        }
        return totalSize;
    }

    public Map<String, Object> getContent() {
        return this.content;
    }

    public CouchbaseDocument setContent(Map<String, Object> content) {
        this.content = content;
        return this;
    }

    public CouchbaseDocument setContent(JsonObject payload) {
        return this.setContent(payload.toMap());
    }

    public int getExpiration() {
        return this.expiration;
    }

    public CouchbaseDocument setExpiration(int expiration) {
        this.expiration = expiration;
        return this;
    }

    public Object getId() {
        return this.id;
    }

    public CouchbaseDocument setId(Object id) {
        this.id = id;
        return this;
    }

    private void verifyValueType(Object value) {
        if (value == null) {
            return;
        }
        Class<?> clazz = value.getClass();
        if (CouchbaseSimpleTypes.DOCUMENT_TYPES.isSimpleType(clazz)) {
            return;
        }
        throw new IllegalArgumentException("Attribute of type " + clazz.getCanonicalName() + " cannot be stored and must be converted.");
    }

    public String toString() {
        return "CouchbaseDocument{id=" + this.id + ", exp=" + this.expiration + ", content=" + this.content + '}';
    }
}

