/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.error.CouchbaseException;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.TemplateSupport;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.convert.join.N1qlJoinResolver;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.event.AfterConvertCallback;
import org.springframework.data.couchbase.core.mapping.event.AfterSaveEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.couchbase.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.couchbase.core.mapping.event.CouchbaseMappingEvent;
import org.springframework.data.couchbase.repository.support.MappingCouchbaseEntityInformation;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class CouchbaseTemplateSupport
implements ApplicationContextAware,
TemplateSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseTemplateSupport.class);
    private final CouchbaseTemplate template;
    private final CouchbaseConverter converter;
    private final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;
    private final TranslationService translationService;
    private EntityCallbacks entityCallbacks;
    private ApplicationContext applicationContext;

    public CouchbaseTemplateSupport(CouchbaseTemplate template, CouchbaseConverter converter, TranslationService translationService) {
        this.template = template;
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
        this.translationService = translationService;
    }

    @Override
    public CouchbaseDocument encodeEntity(Object entityToEncode) {
        this.maybeEmitEvent(new BeforeConvertEvent<Object>(entityToEncode));
        Object maybeNewEntity = this.maybeCallBeforeConvert(entityToEncode, "");
        CouchbaseDocument converted = new CouchbaseDocument();
        this.converter.write(maybeNewEntity, converted);
        this.maybeCallAfterConvert(entityToEncode, converted, "");
        this.maybeEmitEvent(new BeforeSaveEvent<Object>(entityToEncode, converted));
        return converted;
    }

    @Override
    public <T> T decodeEntity(String id, String source, Long cas, Class<T> entityClass, String scope, String collection) {
        CouchbasePersistentEntity persistentEntity = this.couldBePersistentEntity(entityClass);
        if (persistentEntity == null) {
            CouchbaseDocument converted = new CouchbaseDocument(id);
            Set<Map.Entry<String, Object>> set = ((CouchbaseDocument)this.translationService.decode(source, converted)).getContent().entrySet();
            return (T)set.iterator().next().getValue();
        }
        if (id == null) {
            throw new CouchbaseException("__id was null. Either use #{#n1ql.selectEntity} or project __id");
        }
        CouchbaseDocument converted = new CouchbaseDocument(id);
        if (persistentEntity.getVersionProperty() != null) {
            if (cas == null) {
                throw new CouchbaseException("version/cas in the entity but __cas was not in result. Either use #{#n1ql.selectEntity} or project __cas");
            }
            if (cas != 0L) {
                converted.put(persistentEntity.getVersionProperty().getName(), cas);
            }
        }
        Object readEntity = this.converter.read(entityClass, (CouchbaseDocument)this.translationService.decode(source, converted));
        ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(readEntity);
        persistentEntity = this.couldBePersistentEntity(readEntity.getClass());
        if (cas != null && cas != 0L && persistentEntity.getVersionProperty() != null) {
            accessor.setProperty(persistentEntity.getVersionProperty(), (Object)cas);
        }
        N1qlJoinResolver.handleProperties(persistentEntity, accessor, this.template.reactive(), id, scope, collection);
        return (T)accessor.getBean();
    }

    CouchbasePersistentEntity couldBePersistentEntity(Class<?> entityClass) {
        if (ClassUtils.isPrimitiveOrWrapper(entityClass) || entityClass == String.class) {
            return null;
        }
        return (CouchbasePersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
    }

    public Object applyUpdatedCas(Object entity, CouchbaseDocument converted, long cas) {
        Object returnValue;
        ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(entity);
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entity.getClass());
        CouchbasePersistentProperty versionProperty = (CouchbasePersistentProperty)persistentEntity.getVersionProperty();
        if (versionProperty != null) {
            accessor.setProperty((PersistentProperty)versionProperty, (Object)cas);
            returnValue = accessor.getBean();
        } else {
            returnValue = entity;
        }
        this.maybeEmitEvent(new AfterSaveEvent<Object>(returnValue, converted));
        return returnValue;
    }

    public Object applyUpdatedId(Object entity, Object id) {
        ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(entity);
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entity.getClass());
        CouchbasePersistentProperty idProperty = (CouchbasePersistentProperty)persistentEntity.getIdProperty();
        if (idProperty != null) {
            accessor.setProperty((PersistentProperty)idProperty, id);
            return accessor.getBean();
        }
        return entity;
    }

    @Override
    public long getCas(Object entity) {
        Object casObject;
        ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(entity);
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entity.getClass());
        CouchbasePersistentProperty versionProperty = (CouchbasePersistentProperty)persistentEntity.getVersionProperty();
        long cas = 0L;
        if (versionProperty != null && (casObject = accessor.getProperty((PersistentProperty)versionProperty)) instanceof Number) {
            cas = ((Number)casObject).longValue();
        }
        return cas;
    }

    @Override
    public String getJavaNameForEntity(Class<?> clazz) {
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(clazz);
        MappingCouchbaseEntityInformation info = new MappingCouchbaseEntityInformation(persistentEntity);
        return info.getJavaType().getName();
    }

    private <T> ConvertingPropertyAccessor<T> getPropertyAccessor(T source) {
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(source.getClass());
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(accessor, this.converter.getConversionService());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(EntityCallbacks.create((BeanFactory)applicationContext));
        }
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"EntityCallbacks must not be null!");
        this.entityCallbacks = entityCallbacks;
    }

    @Override
    public void maybeEmitEvent(CouchbaseMappingEvent<?> event) {
        if (this.canPublishEvent()) {
            try {
                this.applicationContext.publishEvent(event);
            }
            catch (Exception e) {
                LOG.warn("{} thrown during {}", (Object)e, event);
                throw e;
            }
        } else {
            LOG.info("maybeEmitEvent called, but CouchbaseTemplate not initialized with applicationContext");
        }
    }

    private boolean canPublishEvent() {
        return this.applicationContext != null;
    }

    protected <T> T maybeCallBeforeConvert(T object, String collection) {
        if (this.entityCallbacks != null) {
            return (T)this.entityCallbacks.callback(BeforeConvertCallback.class, object, new Object[]{collection});
        }
        LOG.info("maybeCallBeforeConvert called, but CouchbaseTemplate not initialized with applicationContext");
        return object;
    }

    protected <T> T maybeCallAfterConvert(T object, CouchbaseDocument document, String collection) {
        if (null != this.entityCallbacks) {
            return (T)this.entityCallbacks.callback(AfterConvertCallback.class, object, new Object[]{document, collection});
        }
        LOG.info("maybeCallAfterConvert called, but CouchbaseTemplate not initialized with applicationContext");
        return object;
    }
}

