/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.query;

import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.json.JsonValue;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryScanConsistency;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.query.Meta;
import org.springframework.data.couchbase.core.query.QueryCriteriaDefinition;
import org.springframework.data.couchbase.repository.query.StringBasedN1qlQueryParser;
import org.springframework.data.couchbase.repository.support.MappingCouchbaseEntityInformation;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.Alias;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class Query {
    private final List<QueryCriteriaDefinition> criteria = new ArrayList<QueryCriteriaDefinition>();
    private JsonValue parameters = JsonValue.ja();
    private long skip;
    private int limit;
    private Sort sort = Sort.unsorted();
    private QueryScanConsistency queryScanConsistency;
    private static final Pattern WHERE_PATTERN = Pattern.compile("\\sWHERE\\s");
    private static final Logger LOG = LoggerFactory.getLogger(Query.class);

    public Query() {
    }

    public Query(QueryCriteriaDefinition criteriaDefinition) {
        this.addCriteria(criteriaDefinition);
    }

    public static Query query(QueryCriteriaDefinition criteriaDefinition) {
        return new Query(criteriaDefinition);
    }

    public Query addCriteria(QueryCriteriaDefinition criteriaDefinition) {
        this.criteria.add(criteriaDefinition);
        return this;
    }

    public Query setPositionalParameters(JsonArray parameters) {
        this.parameters = parameters;
        return this;
    }

    public Query setNamedParameters(JsonObject parameters) {
        this.parameters = parameters;
        return this;
    }

    JsonValue getParameters() {
        return this.parameters;
    }

    public Query skip(long skip) {
        this.skip = skip;
        return this;
    }

    public Query limit(int limit) {
        this.limit = limit;
        return this;
    }

    public Query with(Pageable pageable) {
        if (pageable.isUnpaged()) {
            return this;
        }
        this.limit = pageable.getPageSize();
        this.skip = pageable.getOffset();
        return this.with(pageable.getSort());
    }

    public QueryScanConsistency getScanConsistency() {
        return this.queryScanConsistency;
    }

    public Query scanConsistency(QueryScanConsistency queryScanConsistency) {
        this.queryScanConsistency = queryScanConsistency;
        return this;
    }

    public Query with(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        if (sort.isUnsorted()) {
            return this;
        }
        this.sort = this.sort.and(sort);
        return this;
    }

    public void appendSkipAndLimit(StringBuilder sb) {
        if (this.limit > 0) {
            sb.append(" LIMIT ").append(this.limit);
        }
        if (this.skip > 0L) {
            sb.append(" OFFSET ").append(this.skip);
        }
    }

    public void appendSort(StringBuilder sb) {
        if (this.sort.isUnsorted()) {
            return;
        }
        sb.append(" ORDER BY ");
        this.sort.stream().forEach(order -> {
            if (order.isIgnoreCase()) {
                throw new IllegalArgumentException(String.format("Given sort contained an Order for %s with ignore case! Couchbase N1QL does not support sorting ignoring case currently!", order.getProperty()));
            }
            sb.append(order.getProperty()).append(" ").append(order.isAscending() ? "ASC," : "DESC,");
        });
        sb.deleteCharAt(sb.length() - 1);
    }

    public void appendWhere(StringBuilder sb, int[] paramIndexPtr, CouchbaseConverter converter) {
        if (!this.criteria.isEmpty()) {
            this.appendWhereOrAnd(sb);
            boolean first = true;
            for (QueryCriteriaDefinition c : this.criteria) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" AND ");
                }
                sb.append(c.export(paramIndexPtr, this.parameters, converter));
            }
        }
    }

    public void appendWhereString(StringBuilder sb, String whereString) {
        this.appendWhereOrAnd(sb);
        sb.append(whereString);
    }

    public void appendString(StringBuilder sb, String whereString) {
        sb.append(whereString);
    }

    private void appendWhereOrAnd(StringBuilder sb) {
        String querySoFar = sb.toString().toUpperCase();
        Matcher whereMatcher = WHERE_PATTERN.matcher(querySoFar);
        boolean alreadyWhere = false;
        while (!alreadyWhere && whereMatcher.find()) {
            if (!Query.notQuoted(whereMatcher.start(), whereMatcher.end(), querySoFar)) continue;
            alreadyWhere = true;
        }
        if (alreadyWhere) {
            sb.append(" AND ");
        } else {
            sb.append(" WHERE ");
        }
    }

    private static boolean notQuoted(int start, int end, String querySoFar) {
        Matcher quoteMatcher = StringBasedN1qlQueryParser.QUOTE_DETECTION_PATTERN.matcher(querySoFar);
        ArrayList<int[]> quotes = new ArrayList<int[]>();
        while (quoteMatcher.find()) {
            quotes.add(new int[]{quoteMatcher.start(), quoteMatcher.end()});
        }
        for (int[] quote : quotes) {
            if (quote[0] > start || quote[1] < end) continue;
            return false;
        }
        return true;
    }

    public String export(int[] ... paramIndexPtrHolder) {
        StringBuilder sb = new StringBuilder();
        this.appendWhere(sb, paramIndexPtrHolder.length > 0 ? paramIndexPtrHolder[0] : null, null);
        this.appendSort(sb);
        this.appendSkipAndLimit(sb);
        return sb.toString();
    }

    public String toN1qlSelectString(ReactiveCouchbaseTemplate template, String collectionName, Class domainClass, boolean isCount) {
        return this.toN1qlSelectString(template, collectionName, domainClass, null, isCount, null);
    }

    public String toN1qlSelectString(ReactiveCouchbaseTemplate template, Class domainClass, boolean isCount) {
        return this.toN1qlSelectString(template, null, domainClass, null, isCount, null);
    }

    public String toN1qlSelectString(ReactiveCouchbaseTemplate template, String collectionName, Class domainClass, Class returnClass, boolean isCount, String[] distinctFields) {
        StringBasedN1qlQueryParser.N1qlSpelValues n1ql = this.getN1qlSpelValues(template, collectionName, domainClass, returnClass, isCount, distinctFields);
        StringBuilder statement = new StringBuilder();
        this.appendString(statement, n1ql.selectEntity);
        this.appendWhereString(statement, n1ql.filter);
        this.appendWhere(statement, new int[]{0}, template.getConverter());
        this.appendSort(statement);
        this.appendSkipAndLimit(statement);
        return statement.toString();
    }

    public String toN1qlRemoveString(ReactiveCouchbaseTemplate template, String collectionName, Class domainClass) {
        StringBasedN1qlQueryParser.N1qlSpelValues n1ql = this.getN1qlSpelValues(template, collectionName, domainClass, null, false, null);
        StringBuilder statement = new StringBuilder();
        this.appendString(statement, n1ql.delete);
        this.appendWhereString(statement, n1ql.filter);
        this.appendWhere(statement, null, template.getConverter());
        this.appendString(statement, n1ql.returning);
        return statement.toString();
    }

    StringBasedN1qlQueryParser.N1qlSpelValues getN1qlSpelValues(ReactiveCouchbaseTemplate template, String collectionName, Class domainClass, Class returnClass, boolean isCount, String[] distinctFields) {
        String typeKey = template.getConverter().getTypeKey();
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)template.getConverter().getMappingContext().getRequiredPersistentEntity(domainClass);
        MappingCouchbaseEntityInformation info = new MappingCouchbaseEntityInformation(persistentEntity);
        String typeValue = info.getJavaType().getName();
        ClassTypeInformation typeInfo = ClassTypeInformation.from((Class)info.getJavaType());
        Alias alias = template.getConverter().getTypeAlias((TypeInformation<?>)typeInfo);
        if (alias != null && alias.isPresent()) {
            typeValue = alias.toString();
        }
        StringBasedN1qlQueryParser sbnqp = new StringBasedN1qlQueryParser(template.getBucketName(), collectionName, template.getConverter(), domainClass, returnClass, typeKey, typeValue, distinctFields);
        return isCount ? sbnqp.getCountContext() : sbnqp.getStatementContext();
    }

    public QueryOptions buildQueryOptions(QueryOptions options, QueryScanConsistency scanConsistency) {
        if (options == null) {
            options = QueryOptions.queryOptions();
        }
        if (this.getParameters() != null) {
            if (this.getParameters() instanceof JsonArray) {
                options.parameters((JsonArray)this.getParameters());
            } else {
                options.parameters((JsonObject)this.getParameters());
            }
        }
        if (scanConsistency == null || scanConsistency == QueryScanConsistency.NOT_BOUNDED && this.getScanConsistency() != null) {
            scanConsistency = this.getScanConsistency();
        }
        if (scanConsistency != null) {
            options.scanConsistency(scanConsistency);
        }
        return options;
    }

    public void setMeta(Meta metaAnnotation) {
        Meta meta = metaAnnotation;
    }
}

