/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.codec.RawJsonTranscoder;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.kv.GetAnyReplicaOptions;
import java.util.Collection;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveFindFromReplicasByIdOperation;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveFindFromReplicasByIdOperationSupport
implements ReactiveFindFromReplicasByIdOperation {
    private final ReactiveCouchbaseTemplate template;

    ReactiveFindFromReplicasByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveFindFromReplicasByIdOperation.ReactiveFindFromReplicasById<T> findFromReplicasById(Class<T> domainType) {
        return new ReactiveFindFromReplicasByIdSupport<T>(this.template, domainType, domainType, null, this.template.support());
    }

    static class ReactiveFindFromReplicasByIdSupport<T>
    implements ReactiveFindFromReplicasByIdOperation.ReactiveFindFromReplicasById<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        private final String collection;
        private final ReactiveTemplateSupport support;

        ReactiveFindFromReplicasByIdSupport(ReactiveCouchbaseTemplate template, Class<?> domainType, Class<T> returnType, String collection, ReactiveTemplateSupport support) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.collection = collection;
            this.support = support;
        }

        @Override
        public Mono<T> any(String id) {
            return Mono.just((Object)id).flatMap(docId -> {
                GetAnyReplicaOptions options = GetAnyReplicaOptions.getAnyReplicaOptions().transcoder((Transcoder)RawJsonTranscoder.INSTANCE);
                return this.template.getCollection(this.collection).reactive().getAnyReplica(docId, options);
            }).flatMap(result -> this.support.decodeEntity(id, (String)result.contentAs(String.class), result.cas(), this.returnType)).onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        @Override
        public Flux<? extends T> any(Collection<String> ids) {
            return Flux.fromIterable(ids).flatMap(this::any);
        }

        @Override
        public ReactiveFindFromReplicasByIdOperation.TerminatingFindFromReplicasById<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ReactiveFindFromReplicasByIdSupport<T>(this.template, this.domainType, this.returnType, collection, this.support);
        }
    }
}

