/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import java.util.Iterator;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.core.query.QueryCriteria;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class N1qlQueryCreator
extends AbstractQueryCreator<Query, QueryCriteria> {
    private static final String META_ID_PROPERTY = "id";
    private static final String META_CAS_PROPERTY = "cas";
    private final ParameterAccessor accessor;
    private final MappingContext<?, CouchbasePersistentProperty> context;
    private final QueryMethod queryMethod;
    private final CouchbaseConverter converter;
    private final String bucketName;
    static Converter<? super CouchbasePersistentProperty, String> cvtr = source -> new StringBuilder(source.getFieldName().length() + 2).append('`').append(source.getFieldName()).append('`').toString();

    public N1qlQueryCreator(PartTree tree, ParameterAccessor accessor, QueryMethod queryMethod, CouchbaseConverter converter, String bucketName) {
        super(tree, accessor);
        this.accessor = accessor;
        this.context = converter.getMappingContext();
        this.queryMethod = queryMethod;
        this.converter = converter;
        this.bucketName = bucketName;
    }

    protected QueryCriteria create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        CouchbasePersistentProperty property = (CouchbasePersistentProperty)path.getLeafProperty();
        return this.from(part, property, QueryCriteria.where(this.addMetaIfRequired((PersistentPropertyPath<CouchbasePersistentProperty>)path, property)), iterator);
    }

    protected QueryCriteria and(Part part, QueryCriteria base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        CouchbasePersistentProperty property = (CouchbasePersistentProperty)path.getLeafProperty();
        return this.from(part, property, base.and(this.addMetaIfRequired((PersistentPropertyPath<CouchbasePersistentProperty>)path, property)), iterator);
    }

    protected QueryCriteria or(QueryCriteria base, QueryCriteria criteria) {
        return base.or(criteria);
    }

    protected Query complete(QueryCriteria criteria, Sort sort) {
        return (criteria == null ? new Query() : new Query().addCriteria(criteria)).with(sort);
    }

    private QueryCriteria from(Part part, CouchbasePersistentProperty property, QueryCriteria criteria, Iterator<Object> parameters) {
        Part.Type type = part.getType();
        switch (type) {
            case GREATER_THAN: 
            case AFTER: {
                return criteria.gt(parameters.next());
            }
            case GREATER_THAN_EQUAL: {
                return criteria.gte(parameters.next());
            }
            case LESS_THAN: 
            case BEFORE: {
                return criteria.lt(parameters.next());
            }
            case LESS_THAN_EQUAL: {
                return criteria.lte(parameters.next());
            }
            case SIMPLE_PROPERTY: {
                return criteria.eq(parameters.next());
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return criteria.ne(parameters.next());
            }
            case CONTAINING: {
                return criteria.containing(parameters.next());
            }
            case NOT_CONTAINING: {
                return criteria.notContaining(parameters.next());
            }
            case STARTING_WITH: {
                return criteria.startingWith(parameters.next());
            }
            case ENDING_WITH: {
                return criteria.endingWith(parameters.next());
            }
            case LIKE: {
                return criteria.like(parameters.next());
            }
            case NOT_LIKE: {
                return criteria.notLike(parameters.next());
            }
            case WITHIN: {
                return criteria.within(parameters.next());
            }
            case IS_NULL: {
                return criteria.isNull();
            }
            case IS_NOT_NULL: {
                return criteria.isNotNull();
            }
            case IS_EMPTY: {
                return criteria.isNotValued();
            }
            case IS_NOT_EMPTY: {
                return criteria.isValued();
            }
            case EXISTS: {
                return criteria.isNotMissing();
            }
            case REGEX: {
                return criteria.regex(parameters.next());
            }
            case BETWEEN: {
                return criteria.between(parameters.next(), parameters.next());
            }
            case IN: {
                return criteria.in(parameters.next());
            }
            case NOT_IN: {
                return criteria.notIn(parameters.next());
            }
            case TRUE: {
                return criteria.TRUE();
            }
            case FALSE: {
                return criteria.FALSE();
            }
        }
        throw new IllegalArgumentException("Unsupported keyword!");
    }

    private N1QLExpression addMetaIfRequired(PersistentPropertyPath<CouchbasePersistentProperty> persistentPropertyPath, CouchbasePersistentProperty property) {
        if (property.isIdProperty()) {
            return N1QLExpression.path(N1QLExpression.meta(N1QLExpression.i(this.bucketName)), N1QLExpression.i(META_ID_PROPERTY));
        }
        if (property.isVersionProperty()) {
            return N1QLExpression.path(N1QLExpression.meta(N1QLExpression.i(this.bucketName)), N1QLExpression.i(META_CAS_PROPERTY));
        }
        return N1QLExpression.x(persistentPropertyPath.toDotPath(cvtr));
    }
}

