/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.index;

import com.couchbase.client.core.error.IndexExistsException;
import com.couchbase.client.java.Cluster;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.index.CouchbasePersistentEntityIndexResolver;
import org.springframework.data.couchbase.core.index.IndexDefinition;
import org.springframework.data.couchbase.core.index.QueryIndexResolver;
import org.springframework.data.couchbase.core.mapping.CouchbaseMappingContext;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.Document;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextEvent;

public class CouchbasePersistentEntityIndexCreator
implements ApplicationListener<MappingContextEvent<?, ?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CouchbasePersistentEntityIndexCreator.class);
    private final Map<Class<?>, Boolean> classesSeen = new ConcurrentHashMap();
    private final CouchbaseMappingContext mappingContext;
    private final QueryIndexResolver indexResolver;
    private final CouchbaseOperations couchbaseOperations;

    public CouchbasePersistentEntityIndexCreator(CouchbaseMappingContext mappingContext, CouchbaseOperations operations) {
        this.mappingContext = mappingContext;
        this.couchbaseOperations = operations;
        this.indexResolver = QueryIndexResolver.create(mappingContext, operations);
    }

    public void onApplicationEvent(MappingContextEvent<?, ?> event) {
        if (!event.wasEmittedBy((MappingContext)this.mappingContext)) {
            return;
        }
        PersistentEntity entity = event.getPersistentEntity();
        if (entity instanceof CouchbasePersistentEntity) {
            this.checkForIndexes((CouchbasePersistentEntity)entity);
        }
    }

    private void checkForIndexes(CouchbasePersistentEntity<?> entity) {
        Class type = entity.getType();
        if (!this.classesSeen.containsKey(type)) {
            this.classesSeen.put(type, Boolean.TRUE);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Analyzing class " + type + " for index information.");
            }
            this.checkForAndCreateIndexes(entity);
        }
    }

    private void checkForAndCreateIndexes(CouchbasePersistentEntity<?> entity) {
        if (entity.isAnnotationPresent(Document.class)) {
            for (IndexDefinition indexDefinition : this.indexResolver.resolveIndexFor(entity.getTypeInformation())) {
                CouchbasePersistentEntityIndexResolver.IndexDefinitionHolder indexToCreate = indexDefinition instanceof CouchbasePersistentEntityIndexResolver.IndexDefinitionHolder ? (CouchbasePersistentEntityIndexResolver.IndexDefinitionHolder)indexDefinition : new CouchbasePersistentEntityIndexResolver.IndexDefinitionHolder(indexDefinition.getIndexFields(), indexDefinition.getIndexName(), indexDefinition.getIndexPredicate());
                this.createIndex(indexToCreate);
            }
        }
    }

    private void createIndex(CouchbasePersistentEntityIndexResolver.IndexDefinitionHolder indexToCreate) {
        Cluster cluster = this.couchbaseOperations.getCouchbaseClientFactory().getCluster();
        StringBuilder statement = new StringBuilder("CREATE INDEX ").append(indexToCreate.getIndexName()).append(" ON `").append(this.couchbaseOperations.getBucketName()).append("` (").append(String.join((CharSequence)",", indexToCreate.getIndexFields())).append(")");
        if (indexToCreate.getIndexPredicate() != null && !indexToCreate.getIndexPredicate().isEmpty()) {
            statement.append(" WHERE ").append(indexToCreate.getIndexPredicate());
        }
        try {
            cluster.query(statement.toString());
        }
        catch (IndexExistsException ex) {
            LOGGER.debug("Index \"" + indexToCreate.getIndexName() + "\" already exists, ignoring.");
        }
        catch (Exception ex) {
            throw new DataIntegrityViolationException("Could not auto-create index with statement: " + statement.toString(), (Throwable)ex);
        }
    }

    public boolean isIndexCreatorFor(MappingContext<?, ?> context) {
        return ((Object)((Object)this.mappingContext)).equals(context);
    }
}

