/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import java.util.Collections;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.convert.CouchbaseCustomConversions;

public abstract class AbstractCouchbaseConverter
implements CouchbaseConverter,
InitializingBean {
    protected final GenericConversionService conversionService;
    protected EntityInstantiators instantiators = new EntityInstantiators();
    protected CustomConversions conversions = new CouchbaseCustomConversions(Collections.emptyList());

    protected AbstractCouchbaseConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setCustomConversions(CustomConversions conversions) {
        this.conversions = conversions;
    }

    public void setInstantiators(EntityInstantiators instantiators) {
        this.instantiators = instantiators;
    }

    public void afterPropertiesSet() {
        this.conversions.registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    @Override
    public Object convertForWriteIfNeeded(Object value) {
        if (value == null) {
            return null;
        }
        return this.conversions.getCustomWriteTarget(value.getClass()).map(it -> this.conversionService.convert(value, it)).orElse(value);
    }

    @Override
    public Class<?> getWriteClassFor(Class<?> clazz) {
        return this.conversions.getCustomWriteTarget(clazz).orElse(clazz);
    }
}

