/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.cdi;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.springframework.data.couchbase.core.RxJavaCouchbaseOperations;
import org.springframework.data.couchbase.repository.config.ReactiveRepositoryOperationsMapping;
import org.springframework.data.couchbase.repository.support.IndexManager;
import org.springframework.data.couchbase.repository.support.ReactiveCouchbaseRepositoryFactory;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;
import org.springframework.util.Assert;

public class ReactiveCouchbaseRepositoryBean<T>
extends CdiRepositoryBean<T> {
    private final Bean<RxJavaCouchbaseOperations> reactiveCouchbaseOperationsBean;

    public ReactiveCouchbaseRepositoryBean(Bean<RxJavaCouchbaseOperations> reactiveOperations, Set<Annotation> qualifiers, Class<T> repositoryType, BeanManager beanManager, CustomRepositoryImplementationDetector detector) {
        super(qualifiers, repositoryType, beanManager, Optional.of(detector));
        Assert.notNull(reactiveOperations, (String)"Cannot create repository with 'null' for ReactiveCouchbaseOperations.");
        this.reactiveCouchbaseOperationsBean = reactiveOperations;
    }

    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType, Optional<Object> customImplementation) {
        RxJavaCouchbaseOperations reactiveCouchbaseOperations = (RxJavaCouchbaseOperations)this.getDependencyInstance(this.reactiveCouchbaseOperationsBean, RxJavaCouchbaseOperations.class);
        ReactiveRepositoryOperationsMapping reactiveCouchbaseOperationsMapping = new ReactiveRepositoryOperationsMapping(reactiveCouchbaseOperations);
        IndexManager indexManager = new IndexManager();
        ReactiveCouchbaseRepositoryFactory factory = new ReactiveCouchbaseRepositoryFactory(reactiveCouchbaseOperationsMapping, indexManager);
        return (T)customImplementation.map(o -> factory.getRepository(repositoryType, o)).orElseGet(() -> factory.getRepository(repositoryType));
    }

    public Class<? extends Annotation> getScope() {
        return this.reactiveCouchbaseOperationsBean.getScope();
    }
}

