/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.support;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.couchbase.core.CouchbaseExceptionTranslator;
import org.springframework.data.couchbase.core.OperationInterruptedException;
import rx.Observable;

public class TemplateUtils {
    public static final String SELECT_ID = "_ID";
    public static final String SELECT_CAS = "_CAS";
    private static PersistenceExceptionTranslator exceptionTranslator = new CouchbaseExceptionTranslator();

    public static Observable translateError(Throwable e) {
        if (e instanceof RuntimeException) {
            return Observable.error((Throwable)exceptionTranslator.translateExceptionIfPossible((RuntimeException)e));
        }
        if (e instanceof TimeoutException) {
            return Observable.error((Throwable)new QueryTimeoutException(e.getMessage(), e));
        }
        if (e instanceof InterruptedException) {
            return Observable.error((Throwable)((Object)new OperationInterruptedException(e.getMessage(), e)));
        }
        if (e instanceof ExecutionException) {
            return Observable.error((Throwable)((Object)new OperationInterruptedException(e.getMessage(), e)));
        }
        return Observable.error((Throwable)e);
    }
}

