/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import java.io.Serializable;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.core.support.AbstractEntityInformation;

public class MappingCouchbaseEntityInformation<T, ID extends Serializable>
extends AbstractEntityInformation<T, ID>
implements CouchbaseEntityInformation<T, ID> {
    private final CouchbasePersistentEntity<T> entityMetadata;

    public MappingCouchbaseEntityInformation(CouchbasePersistentEntity<T> entity) {
        super(entity.getType());
        this.entityMetadata = entity;
    }

    public ID getId(T entity) {
        CouchbasePersistentProperty idProperty = (CouchbasePersistentProperty)this.entityMetadata.getIdProperty();
        if (idProperty == null) {
            return null;
        }
        try {
            return (ID)((Serializable)BeanWrapper.create(entity, null).getProperty((PersistentProperty)idProperty));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class<ID> getIdType() {
        return ((CouchbasePersistentProperty)this.entityMetadata.getIdProperty()).getType();
    }
}

