/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.monitor;

import com.couchbase.client.CouchbaseClient;
import java.util.HashMap;
import org.springframework.data.couchbase.monitor.AbstractMonitor;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Cluster Information")
public class ClusterInfo
extends AbstractMonitor {
    public ClusterInfo(CouchbaseClient client) {
        super(client);
    }

    @ManagedMetric(description="Total RAM assigned")
    public long getTotalRAMAssigned() {
        return this.convertPotentialLong(this.parseStorageTotals().get("ram").get("total"));
    }

    @ManagedMetric(description="Total RAM used")
    public long getTotalRAMUsed() {
        return this.convertPotentialLong(this.parseStorageTotals().get("ram").get("used"));
    }

    @ManagedMetric(description="Total Disk Space assigned")
    public long getTotalDiskAssigned() {
        return this.convertPotentialLong(this.parseStorageTotals().get("hdd").get("total"));
    }

    @ManagedMetric(description="Total Disk Space used")
    public long getTotalDiskUsed() {
        return this.convertPotentialLong(this.parseStorageTotals().get("hdd").get("used"));
    }

    @ManagedMetric(description="Total Disk Space free")
    public long getTotalDiskFree() {
        return this.convertPotentialLong(this.parseStorageTotals().get("hdd").get("free"));
    }

    @ManagedAttribute(description="Cluster is Balanced")
    public boolean getIsBalanced() {
        return (Boolean)this.fetchPoolInfo().get("balanced");
    }

    @ManagedAttribute(description="Rebalance Status")
    public String getRebalanceStatus() {
        return (String)this.fetchPoolInfo().get("rebalanceStatus");
    }

    @ManagedAttribute(description="Maximum Available Buckets")
    public int getMaxBuckets() {
        return (Integer)this.fetchPoolInfo().get("maxBucketCount");
    }

    private long convertPotentialLong(Object value) {
        if (value instanceof Integer) {
            return new Long(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new IllegalStateException("Cannot convert value to long: " + value);
    }

    private HashMap<String, Object> fetchPoolInfo() {
        return (HashMap)this.getTemplate().getForObject("http://" + this.randomAvailableHostname() + ":8091/pools/default", HashMap.class, new Object[0]);
    }

    private HashMap<String, HashMap> parseStorageTotals() {
        HashMap<String, Object> stats = this.fetchPoolInfo();
        return (HashMap)stats.get("storageTotals");
    }
}

