/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.util.ClassUtils;

public final class DateConverters {
    private static final boolean JODA_TIME_IS_PRESENT = ClassUtils.isPresent((String)"org.joda.time.LocalDate", null);

    private DateConverters() {
    }

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        ArrayList converters = new ArrayList();
        converters.add(DateToLongConverter.INSTANCE);
        converters.add(CalendarToLongConverter.INSTANCE);
        converters.add(LongToDateConverter.INSTANCE);
        converters.add(LongToCalendarConverter.INSTANCE);
        if (JODA_TIME_IS_PRESENT) {
            converters.add(LocalDateToLongConverter.INSTANCE);
            converters.add(LocalDateTimeToLongConverter.INSTANCE);
            converters.add(DateTimeToLongConverter.INSTANCE);
            converters.add(DateMidnightToLongConverter.INSTANCE);
            converters.add(LongToLocalDateConverter.INSTANCE);
            converters.add(LongToLocalDateTimeConverter.INSTANCE);
            converters.add(LongToDateTimeConverter.INSTANCE);
            converters.add(LongToDateMidnightConverter.INSTANCE);
        }
        return converters;
    }

    @ReadingConverter
    public static enum LongToDateMidnightConverter implements Converter<Long, DateMidnight>
    {
        INSTANCE;


        public DateMidnight convert(Long source) {
            return source == null ? null : new DateMidnight((Object)source);
        }
    }

    @ReadingConverter
    public static enum LongToDateTimeConverter implements Converter<Long, DateTime>
    {
        INSTANCE;


        public DateTime convert(Long source) {
            return source == null ? null : new DateTime((Object)source);
        }
    }

    @ReadingConverter
    public static enum LongToLocalDateTimeConverter implements Converter<Long, LocalDateTime>
    {
        INSTANCE;


        public LocalDateTime convert(Long source) {
            return source == null ? null : new LocalDateTime((Object)source);
        }
    }

    @ReadingConverter
    public static enum LongToLocalDateConverter implements Converter<Long, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(Long source) {
            return source == null ? null : new LocalDate((Object)source);
        }
    }

    @WritingConverter
    public static enum DateMidnightToLongConverter implements Converter<DateMidnight, Long>
    {
        INSTANCE;


        public Long convert(DateMidnight source) {
            return source == null ? null : Long.valueOf(source.toDate().getTime());
        }
    }

    @WritingConverter
    public static enum DateTimeToLongConverter implements Converter<DateTime, Long>
    {
        INSTANCE;


        public Long convert(DateTime source) {
            return source == null ? null : Long.valueOf(source.toDate().getTime());
        }
    }

    @WritingConverter
    public static enum LocalDateTimeToLongConverter implements Converter<LocalDateTime, Long>
    {
        INSTANCE;


        public Long convert(LocalDateTime source) {
            return source == null ? null : Long.valueOf(source.toDate().getTime());
        }
    }

    @WritingConverter
    public static enum LocalDateToLongConverter implements Converter<LocalDate, Long>
    {
        INSTANCE;


        public Long convert(LocalDate source) {
            return source == null ? null : Long.valueOf(source.toDate().getTime());
        }
    }

    @ReadingConverter
    public static enum LongToCalendarConverter implements Converter<Long, Calendar>
    {
        INSTANCE;


        public Calendar convert(Long source) {
            if (source == null) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(source * 1000L);
            return calendar;
        }
    }

    @ReadingConverter
    public static enum LongToDateConverter implements Converter<Long, Date>
    {
        INSTANCE;


        public Date convert(Long source) {
            if (source == null) {
                return null;
            }
            Date date = new Date();
            date.setTime(source);
            return date;
        }
    }

    @WritingConverter
    public static enum CalendarToLongConverter implements Converter<Calendar, Long>
    {
        INSTANCE;


        public Long convert(Calendar source) {
            return source == null ? null : Long.valueOf(source.getTimeInMillis() / 1000L);
        }
    }

    @WritingConverter
    public static enum DateToLongConverter implements Converter<Date, Long>
    {
        INSTANCE;


        public Long convert(Date source) {
            return source == null ? null : Long.valueOf(source.getTime());
        }
    }
}

