/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.CouchbaseClient;
import com.couchbase.client.CouchbaseConnectionFactory;
import com.couchbase.client.CouchbaseConnectionFactoryBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.FailureMode;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.couchbase.core.CouchbaseExceptionTranslator;

public class CouchbaseFactoryBean
implements FactoryBean<CouchbaseClient>,
InitializingBean,
DisposableBean,
PersistenceExceptionTranslator {
    public static final String DEFAULT_NODE = "127.0.0.1";
    public static final String DEFAULT_BUCKET = "default";
    public static final String DEFAULT_PASSWORD = "";
    public static final String DEFAULT_DESTROY_METHOD = "shutdown";
    public static final String DEFAULT_LOGGER_PROPERTY = "net.spy.memcached.compat.log.SLF4JLogger";
    private CouchbaseClient couchbaseClient;
    private PersistenceExceptionTranslator exceptionTranslator = new CouchbaseExceptionTranslator();
    private String bucket;
    private String password;
    private List<URI> nodes;
    private final CouchbaseConnectionFactoryBuilder builder = new CouchbaseConnectionFactoryBuilder();

    public void setObservePollInterval(int interval) {
        this.builder.setObsPollInterval((long)interval);
    }

    public void setObservePollMax(int max) {
        this.builder.setObsPollMax(max);
    }

    public void setReconnectThresholdTime(int time) {
        this.builder.setReconnectThresholdTime((long)time, TimeUnit.SECONDS);
    }

    public void setViewTimeout(int timeout) {
        this.builder.setViewTimeout(timeout);
    }

    public void setFailureMode(String mode) {
        this.builder.setFailureMode(FailureMode.valueOf((String)mode));
    }

    public void setOpTimeout(int timeout) {
        this.builder.setOpTimeout((long)timeout);
    }

    public void setOpQueueMaxBlockTime(int time) {
        this.builder.setOpQueueMaxBlockTime((long)time);
    }

    public void destroy() throws Exception {
        this.couchbaseClient.shutdown();
    }

    public CouchbaseClient getObject() throws Exception {
        return this.couchbaseClient;
    }

    public Class<?> getObjectType() {
        return CouchbaseClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHost(String hosts) {
        this.nodes = this.convertHosts(hosts);
    }

    private List<URI> convertHosts(String hosts) {
        String[] split = hosts.split(",");
        ArrayList<URI> nodes = new ArrayList<URI>();
        try {
            for (int i = 0; i < split.length; ++i) {
                nodes.add(new URI("http://" + split[i] + ":8091/pools"));
            }
        }
        catch (URISyntaxException ex) {
            throw new BeanCreationException("Could not convert host list." + ex);
        }
        return nodes;
    }

    public void setNodes(URI[] nodes) {
        this.nodes = this.filterNonNullElementsAsList(nodes);
    }

    private <T> List<T> filterNonNullElementsAsList(T[] elements) {
        if (elements == null) {
            return Collections.emptyList();
        }
        ArrayList<T> candidateElements = new ArrayList<T>();
        for (T element : elements) {
            if (element == null) continue;
            candidateElements.add(element);
        }
        return Collections.unmodifiableList(candidateElements);
    }

    public void afterPropertiesSet() throws Exception {
        this.nodes = this.nodes != null ? this.nodes : Arrays.asList(new URI("http://127.0.0.1:8091/pools"));
        this.bucket = this.bucket != null ? this.bucket : DEFAULT_BUCKET;
        this.password = this.password != null ? this.password : DEFAULT_PASSWORD;
        CouchbaseConnectionFactory factory = this.builder.buildCouchbaseConnection(this.nodes, this.bucket, this.password);
        this.couchbaseClient = new CouchbaseClient(factory);
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }
}

