/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.ObservedException;
import com.couchbase.client.ObservedModifiedException;
import com.couchbase.client.ObservedTimeoutException;
import com.couchbase.client.protocol.views.InvalidViewException;
import com.couchbase.client.vbucket.ConnectionException;
import java.util.concurrent.CancellationException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.couchbase.core.OperationCancellationException;

public class CouchbaseExceptionTranslator
implements PersistenceExceptionTranslator {
    public final DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof ConnectionException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof ObservedException || ex instanceof ObservedTimeoutException || ex instanceof ObservedModifiedException) {
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof CancellationException) {
            throw new OperationCancellationException(ex.getMessage(), ex);
        }
        if (ex instanceof InvalidViewException) {
            throw new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
        }
        throw ex;
    }
}

