/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import java.util.Properties;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.couchbase.core.CouchbaseFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CouchbaseParser
extends AbstractSingleBeanDefinitionParser {
    protected Class getBeanClass(Element element) {
        return CouchbaseFactoryBean.class;
    }

    protected void doParse(Element element, BeanDefinitionBuilder bean) {
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)bean, (Element)element, (String)"host", (String)"host");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)bean, (Element)element, (String)"bucket", (String)"bucket");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)bean, (Element)element, (String)"password", (String)"password");
        this.setLogger();
    }

    private void setLogger() {
        Properties systemProperties = System.getProperties();
        systemProperties.put("net.spy.log.LoggerImpl", "net.spy.memcached.compat.log.SLF4JLogger");
        System.setProperties(systemProperties);
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "couchbase";
    }
}

