/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.couchbase.monitor.ClientInfo;
import org.springframework.data.couchbase.monitor.ClusterInfo;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CouchbaseJmxParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String name = element.getAttribute("couchbase-ref");
        if (!StringUtils.hasText((String)name)) {
            name = "couchbase";
        }
        this.registerJmxComponents(name, element, parserContext);
        return null;
    }

    protected void registerJmxComponents(String refName, Element element, ParserContext parserContext) {
        Object eleSource = parserContext.extractSource((Object)element);
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), eleSource);
        this.createBeanDefEntry(ClientInfo.class, compositeDef, refName, eleSource, parserContext);
        this.createBeanDefEntry(ClusterInfo.class, compositeDef, refName, eleSource, parserContext);
        parserContext.registerComponent((ComponentDefinition)compositeDef);
    }

    protected void createBeanDefEntry(Class<?> clazz, CompositeComponentDefinition compositeDef, String refName, Object eleSource, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        builder.getRawBeanDefinition().setSource(eleSource);
        builder.addConstructorArgReference(refName);
        AbstractBeanDefinition assertDef = builder.getBeanDefinition();
        String assertName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)assertDef);
        compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)assertDef, assertName));
    }
}

