/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import com.couchbase.client.CouchbaseClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.convert.CustomConversions;
import org.springframework.data.couchbase.core.convert.MappingCouchbaseConverter;
import org.springframework.data.couchbase.core.convert.translation.JacksonTranslationService;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;
import org.springframework.data.couchbase.core.mapping.CouchbaseMappingContext;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.Document;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.CamelCaseAbbreviatingFieldNamingStrategy;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
public abstract class AbstractCouchbaseConfiguration {
    protected abstract List<String> bootstrapHosts();

    protected abstract String getBucketName();

    protected abstract String getBucketPassword();

    @Bean(destroyMethod="shutdown")
    public CouchbaseClient couchbaseClient() throws Exception {
        AbstractCouchbaseConfiguration.setLoggerProperty(this.couchbaseLogger());
        return new CouchbaseClient(AbstractCouchbaseConfiguration.bootstrapUris(this.bootstrapHosts()), this.getBucketName(), this.getBucketPassword());
    }

    protected String couchbaseLogger() {
        return "net.spy.memcached.compat.log.SLF4JLogger";
    }

    protected static void setLoggerProperty(String logger) {
        Properties systemProperties = System.getProperties();
        systemProperties.setProperty("net.spy.log.LoggerImpl", logger);
        System.setProperties(systemProperties);
    }

    @Bean
    public CouchbaseTemplate couchbaseTemplate() throws Exception {
        return new CouchbaseTemplate(this.couchbaseClient(), this.mappingCouchbaseConverter(), this.translationService());
    }

    @Bean
    public MappingCouchbaseConverter mappingCouchbaseConverter() throws Exception {
        MappingCouchbaseConverter converter = new MappingCouchbaseConverter((MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty>)this.couchbaseMappingContext());
        converter.setCustomConversions(this.customConversions());
        return converter;
    }

    @Bean
    public TranslationService translationService() {
        JacksonTranslationService jacksonTranslationService = new JacksonTranslationService();
        jacksonTranslationService.afterPropertiesSet();
        return jacksonTranslationService;
    }

    @Bean
    public CouchbaseMappingContext couchbaseMappingContext() throws Exception {
        CouchbaseMappingContext mappingContext = new CouchbaseMappingContext();
        mappingContext.setInitialEntitySet(this.getInitialEntitySet());
        mappingContext.setSimpleTypeHolder(this.customConversions().getSimpleTypeHolder());
        mappingContext.setFieldNamingStrategy(this.fieldNamingStrategy());
        return mappingContext;
    }

    @Bean
    public CustomConversions customConversions() {
        return new CustomConversions(Collections.emptyList());
    }

    protected Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        String basePackage = this.getMappingBasePackage();
        HashSet initialEntitySet = new HashSet();
        if (StringUtils.hasText((String)basePackage)) {
            ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Document.class));
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Persistent.class));
            for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
                initialEntitySet.add(ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)AbstractCouchbaseConfiguration.class.getClassLoader()));
            }
        }
        return initialEntitySet;
    }

    protected String getMappingBasePackage() {
        return this.getClass().getPackage().getName();
    }

    protected boolean abbreviateFieldNames() {
        return false;
    }

    protected FieldNamingStrategy fieldNamingStrategy() {
        return this.abbreviateFieldNames() ? new CamelCaseAbbreviatingFieldNamingStrategy() : PropertyNameFieldNamingStrategy.INSTANCE;
    }

    protected static List<URI> bootstrapUris(List<String> hosts) throws URISyntaxException {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String host : hosts) {
            uris.add(new URI("http://" + host + ":8091/pools"));
        }
        return uris;
    }
}

