/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.util;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.reactive.ReactiveFlowKt;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.util.ReactiveWrappers;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ReactiveWrapperConverters {
    private static final List<ReactiveTypeWrapper<?>> REACTIVE_WRAPPERS = new ArrayList();
    private static final GenericConversionService GENERIC_CONVERSION_SERVICE = new GenericConversionService();
    private static final boolean RXJAVA3_PRESENT = ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.RXJAVA3);
    private static final boolean REACTOR_PRESENT = ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.PROJECT_REACTOR);
    private static final boolean KOTLIN_COROUTNES_PRESENT = ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.KOTLIN_COROUTINES);
    private static final boolean MUTINY_PRESENT = ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.MUTINY);

    private ReactiveWrapperConverters() {
    }

    private static void registerConvertersIn(ConfigurableConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
        if (REACTOR_PRESENT) {
            conversionService.addConverter((Converter)PublisherToMonoConverter.INSTANCE);
            conversionService.addConverter((Converter)PublisherToFluxConverter.INSTANCE);
            if (KOTLIN_COROUTNES_PRESENT) {
                conversionService.addConverter((Converter)PublisherToFlowConverter.INSTANCE);
            }
            if (RegistryHolder.REACTIVE_ADAPTER_REGISTRY != null) {
                conversionService.addConverterFactory((ConverterFactory)ReactiveAdapterConverterFactory.INSTANCE);
            }
        }
    }

    public static boolean supports(Class<?> type) {
        return RegistryHolder.REACTIVE_ADAPTER_REGISTRY != null && RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(type) != null;
    }

    public static TypeInformation<?> unwrapWrapperTypes(TypeInformation<?> type) {
        Assert.notNull(type, (String)"type must not be null");
        Class<?> rawType = type.getType();
        return ReactiveWrapperConverters.supports(rawType) ? ReactiveWrapperConverters.unwrapWrapperTypes(type.getRequiredComponentType()) : type;
    }

    public static <T> T toWrapper(Object reactiveObject, Class<? extends T> targetWrapperType) {
        Assert.notNull((Object)reactiveObject, (String)"Reactive source object must not be null");
        Assert.notNull(targetWrapperType, (String)"Reactive target type must not be null");
        if (targetWrapperType.isAssignableFrom(reactiveObject.getClass())) {
            return (T)reactiveObject;
        }
        Object convert = GENERIC_CONVERSION_SERVICE.convert(reactiveObject, targetWrapperType);
        if (convert == null) {
            throw new IllegalStateException("Wait, what?");
        }
        return (T)convert;
    }

    public static <T> T map(Object reactiveObject, Function<Object, Object> converter) {
        Assert.notNull((Object)reactiveObject, (String)"Reactive source object must not be null");
        Assert.notNull(converter, (String)"Converter must not be null");
        return (T)ReactiveWrapperConverters.getFirst(reactiveObject).map(it -> it.map(reactiveObject, converter)).orElseThrow(() -> new IllegalStateException(String.format("Cannot apply converter to %s", reactiveObject)));
    }

    private static Optional<ReactiveTypeWrapper<?>> getFirst(Object reactiveObject) {
        return REACTIVE_WRAPPERS.stream().filter(it -> ClassUtils.isAssignable(it.getWrapperClass(), reactiveObject.getClass())).findFirst();
    }

    public static boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        Assert.notNull(sourceType, (String)"Source type must not be null");
        Assert.notNull(targetType, (String)"Target type must not be null");
        return GENERIC_CONVERSION_SERVICE.canConvert(sourceType, targetType);
    }

    static {
        if (RXJAVA3_PRESENT) {
            REACTIVE_WRAPPERS.add(RxJava3SingleWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(RxJava3MaybeWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(RxJava3ObservableWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(RxJava3FlowableWrapper.INSTANCE);
        }
        if (REACTOR_PRESENT) {
            REACTIVE_WRAPPERS.add(FluxWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(MonoWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(PublisherWrapper.INSTANCE);
        }
        if (KOTLIN_COROUTNES_PRESENT) {
            REACTIVE_WRAPPERS.add(FlowWrapper.INSTANCE);
        }
        if (MUTINY_PRESENT) {
            REACTIVE_WRAPPERS.add(UniWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(MultiWrapper.INSTANCE);
        }
        ReactiveWrapperConverters.registerConvertersIn((ConfigurableConversionService)GENERIC_CONVERSION_SERVICE);
    }

    private static enum PublisherToMonoConverter implements Converter<Publisher<?>, Mono<?>>
    {
        INSTANCE;


        public @NonNull Mono<?> convert(Publisher<?> source) {
            return Mono.from(source);
        }
    }

    private static enum PublisherToFluxConverter implements Converter<Publisher<?>, Flux<?>>
    {
        INSTANCE;


        public @NonNull Flux<?> convert(Publisher<?> source) {
            return Flux.from(source);
        }
    }

    private static enum PublisherToFlowConverter implements Converter<Publisher<?>, Flow<?>>
    {
        INSTANCE;


        public @NonNull Flow<?> convert(Publisher<?> source) {
            return ReactiveFlowKt.asFlow(source);
        }
    }

    static class RegistryHolder {
        static final @Nullable ReactiveAdapterRegistry REACTIVE_ADAPTER_REGISTRY = ReactiveWrappers.PROJECT_REACTOR_PRESENT ? ReactiveAdapterRegistry.getSharedInstance() : null;

        RegistryHolder() {
        }

        static ReactiveAdapterRegistry getReactiveAdapterRegistry() {
            if (REACTIVE_ADAPTER_REGISTRY == null) {
                throw new IllegalStateException("ReactiveAdapterRegistry not available. Make sure to have Project Reactor on your classpath!");
            }
            return REACTIVE_ADAPTER_REGISTRY;
        }

        public static ReactiveAdapter getAdapter(Class<?> reactiveType, Object source) {
            ReactiveAdapter adapter = RegistryHolder.getReactiveAdapterRegistry().getAdapter(reactiveType, source);
            if (adapter == null) {
                throw new IllegalArgumentException("Cannot convert Reactive Type '%s' (%s) to Publisher".formatted(reactiveType.getName(), source.getClass().getName()));
            }
            return adapter;
        }

        public static ReactiveAdapter getAdapter(Class<?> reactiveType) {
            ReactiveAdapter adapter = RegistryHolder.getReactiveAdapterRegistry().getAdapter(reactiveType);
            if (adapter == null) {
                throw new IllegalArgumentException("No ReactiveAdapter for '%s' conversion registered.".formatted(reactiveType.getName()));
            }
            return adapter;
        }
    }

    private static enum ReactiveAdapterConverterFactory implements ConverterFactory<Object, Object>,
    ConditionalConverter
    {
        INSTANCE;


        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            return this.isSupported(sourceType) || this.isSupported(targetType);
        }

        private boolean isSupported(TypeDescriptor typeDescriptor) {
            return RegistryHolder.REACTIVE_ADAPTER_REGISTRY != null && RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(typeDescriptor.getType()) != null;
        }

        public <T> Converter<Object, T> getConverter(Class<T> targetType) {
            return source -> {
                Publisher publisher = source instanceof Publisher ? (Publisher)source : RegistryHolder.getAdapter(Publisher.class, source).toPublisher(source);
                ReactiveAdapter adapter = RegistryHolder.getAdapter(targetType);
                return adapter.fromPublisher(publisher);
            };
        }
    }

    private static interface ReactiveTypeWrapper<T> {
        public Class<? super T> getWrapperClass();

        public Object map(Object var1, Function<Object, Object> var2);
    }

    private static enum RxJava3SingleWrapper implements ReactiveTypeWrapper<Single<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Single<?>> getWrapperClass() {
            return Single.class;
        }

        public Single<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Single)wrapper).map(function::apply);
        }
    }

    private static enum RxJava3MaybeWrapper implements ReactiveTypeWrapper<Maybe<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Maybe<?>> getWrapperClass() {
            return Maybe.class;
        }

        public Maybe<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Maybe)wrapper).map(function::apply);
        }
    }

    private static enum RxJava3ObservableWrapper implements ReactiveTypeWrapper<Observable<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Observable<?>> getWrapperClass() {
            return Observable.class;
        }

        public Observable<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Observable)wrapper).map(function::apply);
        }
    }

    private static enum RxJava3FlowableWrapper implements ReactiveTypeWrapper<Flowable<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Flowable<?>> getWrapperClass() {
            return Flowable.class;
        }

        public Flowable<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Flowable)wrapper).map(function::apply);
        }
    }

    private static enum FluxWrapper implements ReactiveTypeWrapper<Flux<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Flux<?>> getWrapperClass() {
            return Flux.class;
        }

        public Flux<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Flux)wrapper).map(function);
        }
    }

    private static enum MonoWrapper implements ReactiveTypeWrapper<Mono<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Mono<?>> getWrapperClass() {
            return Mono.class;
        }

        public Mono<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Mono)wrapper).map(function);
        }
    }

    private static enum PublisherWrapper implements ReactiveTypeWrapper<Publisher<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Publisher<?>> getWrapperClass() {
            return Publisher.class;
        }

        public Publisher<?> map(Object wrapper, Function<Object, Object> function) {
            if (wrapper instanceof Mono) {
                return MonoWrapper.INSTANCE.map(wrapper, function);
            }
            if (wrapper instanceof Flux) {
                return FluxWrapper.INSTANCE.map(wrapper, function);
            }
            return FluxWrapper.INSTANCE.map((Object)Flux.from((Publisher)((Publisher)wrapper)), function);
        }
    }

    private static enum FlowWrapper implements ReactiveTypeWrapper<Flow<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Flow<?>> getWrapperClass() {
            return Flow.class;
        }

        public Flow<?> map(Object wrapper, Function<Object, Object> function) {
            return FlowKt.map((Flow)((Flow)wrapper), (o, continuation) -> function.apply(o));
        }
    }

    private static enum UniWrapper implements ReactiveTypeWrapper<Uni<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Uni<?>> getWrapperClass() {
            return Uni.class;
        }

        public Uni<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Uni)wrapper).map(function);
        }
    }

    private static enum MultiWrapper implements ReactiveTypeWrapper<Multi<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Multi<?>> getWrapperClass() {
            return Multi.class;
        }

        public Multi<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Multi)wrapper).map(function);
        }
    }
}

