/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class AnnotationDetectionFieldCallback
implements ReflectionUtils.FieldCallback {
    private final Class<? extends Annotation> annotationType;
    private @Nullable Field field;

    public AnnotationDetectionFieldCallback(Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, (String)"AnnotationType must not be null");
        this.annotationType = annotationType;
    }

    public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
        if (this.field != null) {
            return;
        }
        if (AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, this.annotationType) != null) {
            this.field = field;
        }
    }

    public @Nullable Field getField() {
        return this.field;
    }

    public Field getRequiredField() {
        Field field = this.field;
        if (field == null) {
            throw new IllegalStateException(String.format("No field found for annotation %s", this.annotationType));
        }
        return field;
    }

    public @Nullable Class<?> getType() {
        Field field = this.field;
        return field == null ? null : field.getType();
    }

    public Class<?> getRequiredType() {
        return this.getRequiredField().getType();
    }

    public <T> @Nullable T getValue(Object source) {
        Assert.notNull((Object)source, (String)"Source object must not be null");
        Field field = this.field;
        if (field == null) {
            return null;
        }
        ReflectionUtils.makeAccessible((Field)field);
        return (T)ReflectionUtils.getField((Field)field, (Object)source);
    }
}

