/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.FieldSpec;
import org.springframework.javapoet.TypeName;

public class AotRepositoryFragmentMetadata {
    private final ClassName className;
    private final Map<String, FieldSpec> fields = new HashMap<String, FieldSpec>(3);
    private final Map<String, ConstructorArgument> constructorArguments = new LinkedHashMap<String, ConstructorArgument>(3);

    public AotRepositoryFragmentMetadata(ClassName className) {
        this.className = className;
    }

    public @Nullable String fieldNameOf(Class<?> type) {
        TypeName lookup = TypeName.get(type).withoutAnnotations();
        for (Map.Entry<String, FieldSpec> field : this.fields.entrySet()) {
            if (!field.getValue().type.withoutAnnotations().equals((Object)lookup)) continue;
            return field.getKey();
        }
        return null;
    }

    public ClassName getTargetTypeName() {
        return this.className;
    }

    public String getTargetTypeSimpleName() {
        return this.className.simpleName();
    }

    public String getTargetTypePackageName() {
        return this.className.packageName();
    }

    public boolean hasField(String fieldName) {
        return this.fields.containsKey(fieldName);
    }

    public void addField(String fieldName, TypeName type, Modifier ... modifiers) {
        this.fields.put(fieldName, FieldSpec.builder((TypeName)type, (String)fieldName, (Modifier[])modifiers).build());
    }

    public void addField(FieldSpec fieldSpec) {
        this.fields.put(fieldSpec.name, fieldSpec);
    }

    Map<String, FieldSpec> getFields() {
        return this.fields;
    }

    public Map<String, ConstructorArgument> getConstructorArguments() {
        return this.constructorArguments;
    }

    public void addConstructorArgument(String parameterName, TypeName type) {
        this.addConstructorArgument(parameterName, type, parameterName);
    }

    public void addConstructorArgument(String parameterName, TypeName type, @Nullable String fieldName) {
        this.constructorArguments.put(parameterName, new ConstructorArgument(parameterName, type, fieldName));
    }

    public record ConstructorArgument(String parameterName, TypeName typeName, @Nullable String fieldName) {
        boolean isForLocalField() {
            return this.fieldName != null;
        }
    }
}

