/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.lang.CheckReturnValue;
import org.springframework.lang.Contract;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface FluentQuery<T> {
    @Contract(value="_ -> new")
    @CheckReturnValue
    public FluentQuery<T> sortBy(Sort var1);

    @Contract(value="_ -> new")
    @CheckReturnValue
    default public FluentQuery<T> limit(int limit) {
        throw new UnsupportedOperationException("Limit not supported");
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    public <R> FluentQuery<R> as(Class<R> var1);

    @Contract(value="_ -> new")
    @CheckReturnValue
    default public FluentQuery<T> project(String ... properties) {
        return this.project(Arrays.asList(properties));
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    public FluentQuery<T> project(Collection<String> var1);

    public static interface ReactiveFluentQuery<T>
    extends FluentQuery<T> {
        @Override
        @Contract(value="_ -> new")
        @CheckReturnValue
        public ReactiveFluentQuery<T> sortBy(Sort var1);

        @Override
        @Contract(value="_ -> new")
        @CheckReturnValue
        default public ReactiveFluentQuery<T> limit(int limit) {
            throw new UnsupportedOperationException("Limit not supported");
        }

        @Override
        @Contract(value="_ -> new")
        @CheckReturnValue
        public <R> ReactiveFluentQuery<R> as(Class<R> var1);

        @Override
        @Contract(value="_ -> new")
        @CheckReturnValue
        default public ReactiveFluentQuery<T> project(String ... properties) {
            return this.project(Arrays.asList(properties));
        }

        @Override
        @Contract(value="_ -> new")
        @CheckReturnValue
        public ReactiveFluentQuery<T> project(Collection<String> var1);

        public Mono<T> one();

        public Mono<T> first();

        public Flux<T> all();

        default public Mono<Window<T>> scroll(ScrollPosition scrollPosition) {
            throw new UnsupportedOperationException("Scrolling not supported");
        }

        public Mono<Page<T>> page(Pageable var1);

        public Mono<Long> count();

        public Mono<Boolean> exists();
    }

    public static interface FetchableFluentQuery<T>
    extends FluentQuery<T> {
        @Override
        @Contract(value="_ -> new")
        @CheckReturnValue
        public FetchableFluentQuery<T> sortBy(Sort var1);

        @Override
        @Contract(value="_ -> new")
        @CheckReturnValue
        default public FetchableFluentQuery<T> limit(int limit) {
            throw new UnsupportedOperationException("Limit not supported");
        }

        @Override
        @Contract(value="_ -> new")
        @CheckReturnValue
        public <R> FetchableFluentQuery<R> as(Class<R> var1);

        @Override
        @Contract(value="_ -> new")
        @CheckReturnValue
        default public FetchableFluentQuery<T> project(String ... properties) {
            return this.project(Arrays.asList(properties));
        }

        @Override
        @Contract(value="_ -> new")
        @CheckReturnValue
        public FetchableFluentQuery<T> project(Collection<String> var1);

        default public Optional<T> one() {
            return Optional.ofNullable(this.oneValue());
        }

        @Nullable
        public T oneValue();

        default public Optional<T> first() {
            return Optional.ofNullable(this.firstValue());
        }

        @Nullable
        public T firstValue();

        public List<T> all();

        default public Window<T> scroll(ScrollPosition scrollPosition) {
            throw new UnsupportedOperationException("Scrolling not supported");
        }

        public Page<T> page(Pageable var1);

        public Stream<T> stream();

        public long count();

        public boolean exists();
    }
}

