/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.function.IntFunction;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class OffsetScrollPosition
implements ScrollPosition {
    private static final OffsetScrollPosition initial = new OffsetScrollPosition(0L);
    private final long offset;

    private OffsetScrollPosition(long offset) {
        this.offset = offset;
    }

    public static OffsetScrollPosition initial() {
        return initial;
    }

    public static OffsetScrollPosition of(long offset) {
        if (offset == 0L) {
            return OffsetScrollPosition.initial();
        }
        return new OffsetScrollPosition(offset);
    }

    public static IntFunction<OffsetScrollPosition> positionFunction(long startOffset) {
        Assert.isTrue((startOffset >= 0L ? 1 : 0) != 0, (String)"Start offset must not be negative");
        return startOffset == 0L ? OffsetPositionFunction.ZERO : new OffsetPositionFunction(startOffset);
    }

    @Override
    public boolean isInitial() {
        return this.offset == 0L;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetScrollPosition that = (OffsetScrollPosition)o;
        return this.offset == that.offset;
    }

    public int hashCode() {
        int result = 17;
        return result += 31 * ObjectUtils.nullSafeHashCode((Object)this.offset);
    }

    public String toString() {
        return String.format("OffsetScrollPosition [%s]", this.offset);
    }

    private record OffsetPositionFunction(long startOffset) implements IntFunction<OffsetScrollPosition>
    {
        static final OffsetPositionFunction ZERO = new OffsetPositionFunction(0L);

        @Override
        public OffsetScrollPosition apply(int offset) {
            if (offset < 0) {
                throw new IndexOutOfBoundsException(offset);
            }
            return OffsetScrollPosition.of(this.startOffset + (long)offset + 1L);
        }
    }
}

