/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.MethodLookup;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.util.Assert;

interface MethodLookups {
    public static MethodLookup direct() {
        MethodLookup.MethodPredicate direct = (invoked, candidate) -> candidate.getName().equals(invoked.getName()) && candidate.getParameterCount() == invoked.getParameterCount() && Arrays.equals(candidate.getParameterTypes(), invoked.getParameterTypes());
        return () -> Collections.singletonList(direct);
    }

    public static MethodLookup forRepositoryTypes(RepositoryMetadata repositoryMetadata) {
        return MethodLookups.direct().and(new RepositoryAwareMethodLookup(repositoryMetadata));
    }

    public static MethodLookup forReactiveTypes(RepositoryMetadata repositoryMetadata) {
        return MethodLookups.direct().and(new ReactiveTypeInteropMethodLookup(repositoryMetadata));
    }

    public static class ReactiveTypeInteropMethodLookup
    extends RepositoryAwareMethodLookup {
        private final RepositoryMetadata repositoryMetadata;

        public ReactiveTypeInteropMethodLookup(RepositoryMetadata repositoryMetadata) {
            super(repositoryMetadata);
            this.repositoryMetadata = repositoryMetadata;
        }

        @Override
        public List<MethodLookup.MethodPredicate> getLookups() {
            MethodLookup.MethodPredicate convertibleComparison = (invokedMethod, candidate) -> {
                ArrayList<Supplier<Optional>> suppliers = new ArrayList<Supplier<Optional>>();
                if (ReactiveTypeInteropMethodLookup.usesParametersWithReactiveWrappers(invokedMethod.getMethod())) {
                    suppliers.add(() -> ReactiveTypeInteropMethodLookup.getMethodCandidate(invokedMethod, candidate, ReactiveTypeInteropMethodLookup.assignableWrapperMatch()));
                    suppliers.add(() -> ReactiveTypeInteropMethodLookup.getMethodCandidate(invokedMethod, candidate, ReactiveTypeInteropMethodLookup.wrapperConversionMatch()));
                }
                return suppliers.stream().anyMatch(supplier -> ((Optional)supplier.get()).isPresent());
            };
            MethodLookup.MethodPredicate detailedComparison = (invokedMethod, candidate) -> ReactiveTypeInteropMethodLookup.getMethodCandidate(invokedMethod, candidate, this.matchParameterOrComponentType(this.repositoryMetadata.getRepositoryInterface())).isPresent();
            return Arrays.asList(convertibleComparison, detailedComparison);
        }

        private Predicate<ParameterOverrideCriteria> matchParameterOrComponentType(Class<?> repositoryInterface) {
            return parameterCriteria -> {
                Class parameterType = GenericTypeResolver.resolveParameterType((MethodParameter)parameterCriteria.getDeclared(), (Class)repositoryInterface);
                Type genericType = parameterCriteria.getGenericBaseType();
                if (genericType instanceof TypeVariable && !this.matchesGenericType((TypeVariable)genericType, ResolvableType.forMethodParameter((MethodParameter)parameterCriteria.getDeclared()))) {
                    return false;
                }
                return parameterCriteria.getBaseType().isAssignableFrom(parameterType) && parameterCriteria.isAssignableFromDeclared();
            };
        }

        private static boolean isNonUnwrappingWrapper(Class<?> parameterType) {
            Assert.notNull(parameterType, (String)"Parameter type must not be null!");
            return QueryExecutionConverters.supports(parameterType) && !QueryExecutionConverters.supportsUnwrapping(parameterType);
        }

        private static boolean usesParametersWithReactiveWrappers(Method method) {
            Assert.notNull((Object)method, (String)"Method must not be null!");
            return Arrays.stream(method.getParameterTypes()).anyMatch(ReactiveTypeInteropMethodLookup::isNonUnwrappingWrapper);
        }

        private static Optional<Method> getMethodCandidate(MethodLookup.InvokedMethod invokedMethod, Method candidate, Predicate<ParameterOverrideCriteria> predicate) {
            return Optional.of(candidate).filter(it -> invokedMethod.getName().equals(it.getName())).filter(it -> invokedMethod.getParameterCount() == it.getParameterCount()).filter(it -> ReactiveTypeInteropMethodLookup.parametersMatch(it, invokedMethod.getMethod(), predicate));
        }

        private static boolean parametersMatch(Method baseClassMethod, Method declaredMethod, Predicate<ParameterOverrideCriteria> predicate) {
            return ReactiveTypeInteropMethodLookup.methodParameters(baseClassMethod, declaredMethod).allMatch(predicate);
        }

        private static Predicate<ParameterOverrideCriteria> wrapperConversionMatch() {
            return parameterCriteria -> ReactiveTypeInteropMethodLookup.isNonUnwrappingWrapper(parameterCriteria.getBaseType()) && ReactiveTypeInteropMethodLookup.isNonUnwrappingWrapper(parameterCriteria.getDeclaredType()) && ReactiveWrapperConverters.canConvert(parameterCriteria.getDeclaredType(), parameterCriteria.getBaseType());
        }

        private static Predicate<ParameterOverrideCriteria> assignableWrapperMatch() {
            return parameterCriteria -> ReactiveTypeInteropMethodLookup.isNonUnwrappingWrapper(parameterCriteria.getBaseType()) && ReactiveTypeInteropMethodLookup.isNonUnwrappingWrapper(parameterCriteria.getDeclaredType()) && parameterCriteria.getBaseType().isAssignableFrom(parameterCriteria.getDeclaredType());
        }

        private static Stream<ParameterOverrideCriteria> methodParameters(Method first, Method second) {
            Assert.isTrue((first.getParameterCount() == second.getParameterCount() ? 1 : 0) != 0, (String)"Method parameter count must be equal!");
            return IntStream.range(0, first.getParameterCount()).mapToObj(index -> ParameterOverrideCriteria.of(new MethodParameter(first, index), new MethodParameter(second, index)));
        }

        static final class ParameterOverrideCriteria {
            private final MethodParameter base;
            private final MethodParameter declared;

            public Class<?> getBaseType() {
                return this.base.getParameterType();
            }

            public Type getGenericBaseType() {
                return this.base.getGenericParameterType();
            }

            public Class<?> getDeclaredType() {
                return this.declared.getParameterType();
            }

            public boolean isAssignableFromDeclared() {
                return this.getBaseType().isAssignableFrom(this.getDeclaredType());
            }

            private ParameterOverrideCriteria(MethodParameter base, MethodParameter declared) {
                this.base = base;
                this.declared = declared;
            }

            public static ParameterOverrideCriteria of(MethodParameter base, MethodParameter declared) {
                return new ParameterOverrideCriteria(base, declared);
            }

            public MethodParameter getBase() {
                return this.base;
            }

            public MethodParameter getDeclared() {
                return this.declared;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ParameterOverrideCriteria)) {
                    return false;
                }
                ParameterOverrideCriteria other = (ParameterOverrideCriteria)o;
                MethodParameter this$base = this.getBase();
                MethodParameter other$base = other.getBase();
                if (this$base == null ? other$base != null : !this$base.equals(other$base)) {
                    return false;
                }
                MethodParameter this$declared = this.getDeclared();
                MethodParameter other$declared = other.getDeclared();
                return !(this$declared == null ? other$declared != null : !this$declared.equals(other$declared));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MethodParameter $base = this.getBase();
                result = result * 59 + ($base == null ? 43 : $base.hashCode());
                MethodParameter $declared = this.getDeclared();
                result = result * 59 + ($declared == null ? 43 : $declared.hashCode());
                return result;
            }

            public String toString() {
                return "MethodLookups.ReactiveTypeInteropMethodLookup.ParameterOverrideCriteria(base=" + this.getBase() + ", declared=" + this.getDeclared() + ")";
            }
        }
    }

    public static class RepositoryAwareMethodLookup
    implements MethodLookup {
        private static final TypeVariable<Class<Repository>>[] PARAMETERS = Repository.class.getTypeParameters();
        private static final String DOMAIN_TYPE_NAME = PARAMETERS[0].getName();
        private static final String ID_TYPE_NAME = PARAMETERS[1].getName();
        private final ResolvableType entityType;
        private final ResolvableType idType;
        private final Class<?> repositoryInterface;

        public RepositoryAwareMethodLookup(RepositoryMetadata repositoryMetadata) {
            Assert.notNull((Object)repositoryMetadata, (String)"Repository metadata must not be null!");
            this.entityType = ResolvableType.forClass(repositoryMetadata.getDomainType());
            this.idType = ResolvableType.forClass(repositoryMetadata.getIdType());
            this.repositoryInterface = repositoryMetadata.getRepositoryInterface();
        }

        @Override
        public List<MethodLookup.MethodPredicate> getLookups() {
            MethodLookup.MethodPredicate detailedComparison = (invoked, candidate) -> Optional.of(candidate).filter(baseClassMethod -> baseClassMethod.getName().equals(invoked.getName())).filter(baseClassMethod -> baseClassMethod.getParameterCount() == invoked.getParameterCount()).filter(baseClassMethod -> this.parametersMatch(invoked.getMethod(), (Method)baseClassMethod)).isPresent();
            return Collections.singletonList(detailedComparison);
        }

        protected boolean matchesGenericType(TypeVariable<?> variable, ResolvableType parameterType) {
            Object declaration = variable.getGenericDeclaration();
            if (declaration instanceof Class) {
                if (ID_TYPE_NAME.equals(variable.getName()) && parameterType.isAssignableFrom(this.idType)) {
                    return true;
                }
                Type boundType = variable.getBounds()[0];
                String referenceName = boundType instanceof TypeVariable ? boundType.toString() : variable.toString();
                return DOMAIN_TYPE_NAME.equals(referenceName) && parameterType.isAssignableFrom(this.entityType);
            }
            for (Type type : variable.getBounds()) {
                if (!ResolvableType.forType((Type)type).isAssignableFrom(parameterType)) continue;
                return true;
            }
            return false;
        }

        private boolean parametersMatch(Method invokedMethod, Method candidate) {
            Class<?>[] methodParameterTypes = invokedMethod.getParameterTypes();
            Type[] genericTypes = candidate.getGenericParameterTypes();
            Class<?>[] types = candidate.getParameterTypes();
            for (int i = 0; i < genericTypes.length; ++i) {
                Type genericType = genericTypes[i];
                Class<?> type = types[i];
                MethodParameter parameter = new MethodParameter(invokedMethod, i);
                Class parameterType = GenericTypeResolver.resolveParameterType((MethodParameter)parameter, this.repositoryInterface);
                if (!(genericType instanceof TypeVariable ? !this.matchesGenericType((TypeVariable)genericType, ResolvableType.forMethodParameter((MethodParameter)parameter)) : !types[i].equals(parameterType) && (!type.isAssignableFrom(parameterType) || !type.equals(methodParameterTypes[i])))) continue;
                return false;
            }
            return true;
        }
    }
}

