/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.stream.IntStream;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.data.convert.ClassGeneratingEntityInstantiator;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.lang.Nullable;

public class KotlinClassGeneratingEntityInstantiator
extends ClassGeneratingEntityInstantiator {
    @Override
    protected EntityInstantiator doCreateEntityInstantiator(PersistentEntity<?, ?> entity) {
        PreferredConstructor<?, ?> defaultConstructor;
        PreferredConstructor<?, ?> constructor = entity.getPersistenceConstructor();
        if (ReflectionUtils.isSupportedKotlinClass(entity.getType()) && constructor != null && (defaultConstructor = new DefaultingKotlinConstructorResolver(entity).getDefaultConstructor()) != null) {
            ClassGeneratingEntityInstantiator.ObjectInstantiator instantiator = this.createObjectInstantiator(entity, defaultConstructor);
            return new DefaultingKotlinClassInstantiatorAdapter(instantiator, constructor);
        }
        return super.doCreateEntityInstantiator(entity);
    }

    static class DefaultingKotlinClassInstantiatorAdapter
    implements EntityInstantiator {
        private final ClassGeneratingEntityInstantiator.ObjectInstantiator instantiator;
        private final List<KParameter> kParameters;
        private final Constructor<?> synthetic;

        DefaultingKotlinClassInstantiatorAdapter(ClassGeneratingEntityInstantiator.ObjectInstantiator instantiator, PreferredConstructor<?, ?> constructor) {
            KFunction kotlinConstructor = ReflectJvmMapping.getKotlinFunction(constructor.getConstructor());
            if (kotlinConstructor == null) {
                throw new IllegalArgumentException("No corresponding Kotlin constructor found for " + constructor.getConstructor());
            }
            this.instantiator = instantiator;
            this.kParameters = kotlinConstructor.getParameters();
            this.synthetic = constructor.getConstructor();
        }

        @Override
        public <T, E extends PersistentEntity<? extends T, P>, P extends PersistentProperty<P>> T createInstance(E entity, ParameterValueProvider<P> provider) {
            int i;
            PreferredConstructor<T, P> preferredConstructor = entity.getPersistenceConstructor();
            if (preferredConstructor == null) {
                throw new IllegalArgumentException("PreferredConstructor must not be null!");
            }
            int[] defaulting = new int[this.synthetic.getParameterCount() / 32 + 1];
            Object[] params = ClassGeneratingEntityInstantiator.allocateArguments(this.synthetic.getParameterCount() + defaulting.length + 1);
            int userParameterCount = this.kParameters.size();
            List<PreferredConstructor.Parameter<Object, P>> parameters = preferredConstructor.getParameters();
            for (i = 0; i < userParameterCount; ++i) {
                int slot = i / 32;
                int offset = slot * 32;
                Object param = provider.getParameterValue(parameters.get(i));
                KParameter kParameter = this.kParameters.get(i);
                if (kParameter.isOptional() && param == null) {
                    defaulting[slot] = defaulting[slot] | 1 << i - offset;
                }
                params[i] = param;
            }
            for (i = 0; i < defaulting.length; ++i) {
                params[userParameterCount + i] = defaulting[i];
            }
            return (T)this.instantiator.newInstance(params);
        }
    }

    static class DefaultingKotlinConstructorResolver {
        @Nullable
        private final PreferredConstructor<?, ?> defaultConstructor;

        DefaultingKotlinConstructorResolver(PersistentEntity<?, ?> entity) {
            Constructor<?> hit = DefaultingKotlinConstructorResolver.resolveDefaultConstructor(entity);
            PreferredConstructor<?, ?> persistenceConstructor = entity.getPersistenceConstructor();
            this.defaultConstructor = hit != null && persistenceConstructor != null ? new PreferredConstructor(hit, persistenceConstructor.getParameters().toArray(new PreferredConstructor.Parameter[0])) : null;
        }

        @Nullable
        private static Constructor<?> resolveDefaultConstructor(PersistentEntity<?, ?> entity) {
            PreferredConstructor<?, ?> persistenceConstructor = entity.getPersistenceConstructor();
            if (persistenceConstructor == null) {
                return null;
            }
            Constructor<?> hit = null;
            Constructor<?> constructor = persistenceConstructor.getConstructor();
            for (Constructor<?> candidate : entity.getType().getDeclaredConstructors()) {
                if (!candidate.isSynthetic() || constructor.getParameterCount() == 0 || constructor.getParameterCount() + 2 > candidate.getParameterCount()) continue;
                Parameter[] constructorParameters = constructor.getParameters();
                Parameter[] candidateParameters = candidate.getParameters();
                if (!candidateParameters[candidateParameters.length - 1].getType().getName().equals("kotlin.jvm.internal.DefaultConstructorMarker") || !DefaultingKotlinConstructorResolver.parametersMatch(constructorParameters, candidateParameters)) continue;
                hit = candidate;
                break;
            }
            return hit;
        }

        private static boolean parametersMatch(Parameter[] constructorParameters, Parameter[] candidateParameters) {
            return IntStream.range(0, constructorParameters.length).allMatch(i -> constructorParameters[i].getType().equals(candidateParameters[i].getType()));
        }

        @Nullable
        PreferredConstructor<?, ?> getDefaultConstructor() {
            return this.defaultConstructor;
        }
    }
}

