/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.springframework.data.annotation.Id;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ReflectionEntityInformation<T, ID extends Serializable>
extends AbstractEntityInformation<T, ID> {
    private static final Class<Id> DEFAULT_ID_ANNOTATION = Id.class;
    private Field field;

    public ReflectionEntityInformation(Class<T> domainClass) {
        this(domainClass, DEFAULT_ID_ANNOTATION);
    }

    public ReflectionEntityInformation(Class<T> domainClass, final Class<? extends Annotation> annotation) {
        super(domainClass);
        Assert.notNull(annotation, (String)"Annotation must not be null!");
        ReflectionUtils.doWithFields(domainClass, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                if (field.getAnnotation(annotation) != null) {
                    ReflectionEntityInformation.this.field = field;
                    return;
                }
            }
        });
        Assert.notNull((Object)this.field, (String)String.format("No field annotated with %s found!", annotation.toString()));
        ReflectionUtils.makeAccessible((Field)this.field);
    }

    @Override
    public ID getId(Object entity) {
        return (ID)(entity == null ? null : (Serializable)ReflectionUtils.getField((Field)this.field, (Object)entity));
    }

    @Override
    public Class<ID> getIdType() {
        return this.field.getType();
    }
}

