/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.annotation.TypeAlias;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.mapping.model.IdPropertyIdentifierAccessor;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.MutablePersistentEntity;
import org.springframework.data.mapping.model.PreferredConstructorDiscoverer;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BasicPersistentEntity<T, P extends PersistentProperty<P>>
implements MutablePersistentEntity<T, P> {
    private final PreferredConstructor<T, P> constructor;
    private final TypeInformation<T> information;
    private final List<P> properties;
    private final Comparator<P> comparator;
    private final Set<Association<P>> associations;
    private final Map<String, P> propertyCache;
    private final Map<Class<? extends Annotation>, Annotation> annotationCache;
    private P idProperty;
    private P versionProperty;

    public BasicPersistentEntity(TypeInformation<T> information) {
        this(information, null);
    }

    public BasicPersistentEntity(TypeInformation<T> information, Comparator<P> comparator) {
        Assert.notNull(information);
        this.information = information;
        this.properties = new ArrayList<P>();
        this.comparator = comparator;
        this.constructor = new PreferredConstructorDiscoverer(information, this).getConstructor();
        this.associations = comparator == null ? new HashSet() : new TreeSet<P>(new AssociationComparator<P>(comparator));
        this.propertyCache = new HashMap<String, P>();
        this.annotationCache = new HashMap<Class<? extends Annotation>, Annotation>();
    }

    @Override
    public PreferredConstructor<T, P> getPersistenceConstructor() {
        return this.constructor;
    }

    @Override
    public boolean isConstructorArgument(PersistentProperty<?> property) {
        return this.constructor == null ? false : this.constructor.isConstructorParameter(property);
    }

    @Override
    public boolean isIdProperty(PersistentProperty<?> property) {
        return this.idProperty == null ? false : this.idProperty.equals(property);
    }

    @Override
    public boolean isVersionProperty(PersistentProperty<?> property) {
        return this.versionProperty == null ? false : this.versionProperty.equals(property);
    }

    @Override
    public String getName() {
        return this.getType().getName();
    }

    @Override
    public P getIdProperty() {
        return this.idProperty;
    }

    @Override
    public P getVersionProperty() {
        return this.versionProperty;
    }

    @Override
    public boolean hasIdProperty() {
        return this.idProperty != null;
    }

    @Override
    public boolean hasVersionProperty() {
        return this.versionProperty != null;
    }

    @Override
    public void addPersistentProperty(P property) {
        P candidate;
        Assert.notNull(property);
        if (this.properties.contains(property)) {
            return;
        }
        this.properties.add(property);
        if (!this.propertyCache.containsKey(property.getName())) {
            this.propertyCache.put(property.getName(), property);
        }
        if ((candidate = this.returnPropertyIfBetterIdPropertyCandidateOrNull(property)) != null) {
            this.idProperty = candidate;
        }
        if (property.isVersionProperty()) {
            if (this.versionProperty != null) {
                throw new MappingException(String.format("Attempt to add version property %s but already have property %s registered as version. Check your mapping configuration!", property.getField(), this.versionProperty.getField()));
            }
            this.versionProperty = property;
        }
    }

    protected P returnPropertyIfBetterIdPropertyCandidateOrNull(P property) {
        if (!property.isIdProperty()) {
            return null;
        }
        if (this.idProperty != null) {
            throw new MappingException(String.format("Attempt to add id property %s but already have property %s registered as id. Check your mapping configuration!", property.getField(), this.idProperty.getField()));
        }
        return property;
    }

    @Override
    public void addAssociation(Association<P> association) {
        if (!this.associations.contains(association)) {
            this.associations.add(association);
        }
    }

    @Override
    public P getPersistentProperty(String name) {
        return (P)((PersistentProperty)this.propertyCache.get(name));
    }

    @Override
    public P getPersistentProperty(Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, (String)"Annotation type must not be null!");
        for (PersistentProperty persistentProperty : this.properties) {
            if (!persistentProperty.isAnnotationPresent(annotationType)) continue;
            return (P)persistentProperty;
        }
        for (Association association : this.associations) {
            Object property = association.getInverse();
            if (!property.isAnnotationPresent(annotationType)) continue;
            return property;
        }
        return null;
    }

    @Override
    public Class<T> getType() {
        return this.information.getType();
    }

    @Override
    public Object getTypeAlias() {
        TypeAlias alias = (TypeAlias)AnnotatedElementUtils.findMergedAnnotation(this.getType(), TypeAlias.class);
        return alias == null ? null : (StringUtils.hasText((String)alias.value()) ? alias.value() : null);
    }

    @Override
    public TypeInformation<T> getTypeInformation() {
        return this.information;
    }

    @Override
    public void doWithProperties(PropertyHandler<P> handler) {
        Assert.notNull(handler);
        for (PersistentProperty property : this.properties) {
            if (property.isTransient() || property.isAssociation()) continue;
            handler.doWithPersistentProperty(property);
        }
    }

    @Override
    public void doWithProperties(SimplePropertyHandler handler) {
        Assert.notNull((Object)handler);
        for (PersistentProperty property : this.properties) {
            if (property.isTransient() || property.isAssociation()) continue;
            handler.doWithPersistentProperty(property);
        }
    }

    @Override
    public void doWithAssociations(AssociationHandler<P> handler) {
        Assert.notNull(handler);
        for (Association<P> association : this.associations) {
            handler.doWithAssociation(association);
        }
    }

    @Override
    public void doWithAssociations(SimpleAssociationHandler handler) {
        Assert.notNull((Object)handler);
        for (Association<P> association : this.associations) {
            handler.doWithAssociation(association);
        }
    }

    @Override
    public <A extends Annotation> A findAnnotation(Class<A> annotationType) {
        if (this.annotationCache.containsKey(annotationType)) {
            return (A)this.annotationCache.get(annotationType);
        }
        Annotation annotation = AnnotatedElementUtils.findMergedAnnotation(this.getType(), annotationType);
        this.annotationCache.put(annotationType, annotation);
        return (A)annotation;
    }

    @Override
    public void verify() {
        if (this.comparator != null) {
            Collections.sort(this.properties, this.comparator);
        }
    }

    @Override
    public PersistentPropertyAccessor getPropertyAccessor(Object bean) {
        Assert.notNull((Object)bean, (String)"Target bean must not be null!");
        Assert.isTrue((boolean)this.getType().isInstance(bean), (String)"Target bean is not of type of the persistent entity!");
        return new BeanWrapper<Object>(bean);
    }

    @Override
    public IdentifierAccessor getIdentifierAccessor(Object bean) {
        Assert.notNull((Object)bean, (String)"Target bean must not be null!");
        Assert.isTrue((boolean)this.getType().isInstance(bean), (String)"Target bean is not of type of the persistent entity!");
        return this.hasIdProperty() ? new IdPropertyIdentifierAccessor(this, bean) : NullReturningIdentifierAccessor.INSTANCE;
    }

    private static final class AssociationComparator<P extends PersistentProperty<P>>
    implements Comparator<Association<P>>,
    Serializable {
        private static final long serialVersionUID = 4508054194886854513L;
        private final Comparator<P> delegate;

        public AssociationComparator(Comparator<P> delegate) {
            Assert.notNull(delegate);
            this.delegate = delegate;
        }

        @Override
        public int compare(Association<P> left, Association<P> right) {
            return this.delegate.compare(left.getInverse(), right.getInverse());
        }
    }

    private static enum NullReturningIdentifierAccessor implements IdentifierAccessor
    {
        INSTANCE;


        @Override
        public Object getIdentifier() {
            return null;
        }
    }
}

