/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.aot;

import java.util.List;
import org.springframework.data.cassandra.repository.aot.AotQuery;
import org.springframework.data.cassandra.repository.query.ParameterBinding;

abstract class StringAotQuery
extends AotQuery {
    private StringAotQuery(List<ParameterBinding> parameterBindings) {
        super(parameterBindings);
    }

    static StringAotQuery of(String query2, List<ParameterBinding> parameterBindings, boolean count, boolean exists) {
        return new DeclaredAotQuery(query2, parameterBindings, count, exists);
    }

    static StringAotQuery named(String queryName, String query2, List<ParameterBinding> parameterBindings, boolean count, boolean exists) {
        return new NamedStringAotQuery(queryName, query2, parameterBindings, count, exists);
    }

    public abstract String getQueryString();

    public String toString() {
        return this.getQueryString();
    }

    static class DeclaredAotQuery
    extends StringAotQuery {
        private final String query;
        private final boolean count;
        private final boolean exists;

        DeclaredAotQuery(String query2, List<ParameterBinding> parameterBindings, boolean count, boolean exists) {
            super(parameterBindings);
            this.query = query2;
            this.count = count;
            this.exists = exists;
        }

        @Override
        public boolean isCount() {
            return this.count;
        }

        @Override
        public boolean isExists() {
            return this.exists;
        }

        @Override
        public String getQueryString() {
            return this.query;
        }
    }

    static class NamedStringAotQuery
    extends DeclaredAotQuery {
        private final String queryName;

        NamedStringAotQuery(String queryName, String query2, List<ParameterBinding> parameterBindings, boolean count, boolean exists) {
            super(query2, parameterBindings, count, exists);
            this.queryName = queryName;
        }

        public String getQueryName() {
            return this.queryName;
        }
    }
}

