/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.session;

import com.datastax.oss.driver.api.core.AsyncPagingIterable;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.data.cassandra.ReactiveResultSet;
import org.springframework.data.cassandra.ReactiveSession;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultBridgedReactiveSession
implements ReactiveSession {
    private final Log log = LogFactory.getLog(this.getClass());
    private final CqlSession session;

    public DefaultBridgedReactiveSession(CqlSession session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        if (session instanceof TargetSource) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = session.getClass().getInterfaces()) {
                if (!anInterface.getName().endsWith("ObservationDecoratedProxy")) continue;
                session = (CqlSession)AopProxyUtils.getSingletonTarget((Object)session);
            }
        }
        if (session == null) {
            throw new IllegalArgumentException("Cannot extract CqlSession from %s".formatted(session));
        }
        this.session = session;
    }

    @Override
    public Metadata getMetadata() {
        return this.session.getMetadata();
    }

    @Override
    public Optional<CqlIdentifier> getKeyspace() {
        return this.session.getKeyspace();
    }

    @Override
    public boolean isClosed() {
        return this.session.isClosed();
    }

    @Override
    public DriverContext getContext() {
        return this.session.getContext();
    }

    @Override
    public Mono<ReactiveResultSet> execute(String query2) {
        Assert.hasText((String)query2, (String)"Query must not be empty");
        return this.execute((Statement<?>)SimpleStatement.newInstance((String)query2));
    }

    @Override
    public Mono<ReactiveResultSet> execute(String query2, Object ... values) {
        Assert.hasText((String)query2, (String)"Query must not be empty");
        return this.execute((Statement<?>)SimpleStatement.newInstance((String)query2, (Object[])values));
    }

    @Override
    public Mono<ReactiveResultSet> execute(String query2, Map<String, Object> values) {
        Assert.hasText((String)query2, (String)"Query must not be empty");
        return this.execute((Statement<?>)SimpleStatement.newInstance((String)query2, values));
    }

    @Override
    public Mono<ReactiveResultSet> execute(Statement<?> statement) {
        Assert.notNull(statement, (String)"Statement must not be null");
        return Mono.fromCompletionStage(() -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Executing statement [%s]", DefaultBridgedReactiveSession.getCql(statement)));
            }
            return this.session.executeAsync(statement);
        }).map(DefaultReactiveResultSet::new);
    }

    @Override
    public Mono<PreparedStatement> prepare(String query2) {
        Assert.hasText((String)query2, (String)"Query must not be empty");
        return this.prepare(SimpleStatement.newInstance((String)query2));
    }

    @Override
    public Mono<PreparedStatement> prepare(SimpleStatement statement) {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        return Mono.fromCompletionStage(() -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Preparing statement [%s]", DefaultBridgedReactiveSession.getCql(statement)));
            }
            return this.session.prepareAsync(statement);
        });
    }

    private static String getCql(Object statement) {
        if (statement instanceof SimpleStatement) {
            return ((SimpleStatement)statement).getQuery();
        }
        if (statement instanceof PreparedStatement) {
            return ((PreparedStatement)statement).getQuery();
        }
        if (statement instanceof BoundStatement) {
            return DefaultBridgedReactiveSession.getCql(((BoundStatement)statement).getPreparedStatement());
        }
        if (statement instanceof BatchStatement) {
            StringBuilder builder = new StringBuilder();
            for (BatchableStatement batchableStatement : (BatchStatement)statement) {
                String query2 = DefaultBridgedReactiveSession.getCql(batchableStatement);
                builder.append(query2).append(query2.endsWith(";") ? "" : ";");
            }
            return builder.toString();
        }
        return String.format("Unknown: %s", statement);
    }

    @Override
    public void close() {
        this.session.close();
    }

    static class DefaultReactiveResultSet
    implements ReactiveResultSet {
        private final AsyncResultSet resultSet;
        private final boolean wasApplied;

        DefaultReactiveResultSet(AsyncResultSet resultSet) {
            boolean wasApplied;
            this.resultSet = resultSet;
            try {
                wasApplied = resultSet.wasApplied();
            }
            catch (Exception e) {
                wasApplied = false;
            }
            this.wasApplied = wasApplied;
        }

        @Override
        public Flux<Row> rows() {
            return Mono.just((Object)this.resultSet).expand(asyncResultSet -> {
                if (asyncResultSet.hasMorePages()) {
                    return Mono.fromCompletionStage((CompletionStage)asyncResultSet.fetchNextPage());
                }
                return Mono.empty();
            }).flatMapIterable(AsyncPagingIterable::currentPage);
        }

        @Override
        public Flux<Row> availableRows() {
            return Flux.fromIterable((Iterable)this.resultSet.currentPage());
        }

        @Override
        public ColumnDefinitions getColumnDefinitions() {
            return this.resultSet.getColumnDefinitions();
        }

        @Override
        public boolean wasApplied() {
            return this.wasApplied;
        }

        @Override
        public ExecutionInfo getExecutionInfo() {
            return this.resultSet.getExecutionInfo();
        }

        @Override
        public List<ExecutionInfo> getAllExecutionInfo() {
            return Collections.singletonList(this.getExecutionInfo());
        }
    }
}

