/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collector;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.util.Assert;

class AsyncResultStream<T> {
    private final AsyncResultSet resultSet;
    private final RowMapper<T> mapper;

    private AsyncResultStream(AsyncResultSet resultSet, RowMapper<T> mapper) {
        this.resultSet = resultSet;
        this.mapper = mapper;
    }

    static AsyncResultStream<Row> from(AsyncResultSet resultSet) {
        Assert.notNull((Object)resultSet, (String)"AsyncResultSet must not be null");
        return new AsyncResultStream<Row>(resultSet, (row, rowNum) -> row);
    }

    <R> AsyncResultStream<R> map(RowMapper<R> mapper) {
        Assert.notNull(mapper, (String)"RowMapper must not be null");
        return new AsyncResultStream<R>(this.resultSet, mapper);
    }

    <R, A> CompletableFuture<R> collect(Collector<? super T, A, R> collector) {
        Assert.notNull(collector, (String)"Collector must not be null");
        CompletableFuture future = new CompletableFuture();
        CollectState collectState = new CollectState(collector);
        collectState.collectAsync(future, this.resultSet);
        return future;
    }

    CompletableFuture<Void> forEach(Consumer<T> action) {
        Assert.notNull(action, (String)"Action must not be null");
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ForwardLoopState loopState = new ForwardLoopState(action);
        loopState.forEachAsync(future, this.resultSet);
        return future;
    }

    class CollectState<A, R> {
        private final AtomicInteger rowNumber = new AtomicInteger();
        private final A intermediate;
        private final Collector<? super T, A, R> collector;

        CollectState(Collector<? super T, A, R> collector) {
            this.collector = collector;
            this.intermediate = collector.supplier().get();
        }

        void collectPage(Iterable<Row> rows) {
            for (Row row : rows) {
                this.collector.accumulator().accept(this.intermediate, AsyncResultStream.this.mapper.mapRow(row, this.rowNumber.incrementAndGet()));
            }
        }

        R finish() {
            return this.collector.finisher().apply(this.intermediate);
        }

        void collectAsync(CompletableFuture<R> target, AsyncResultSet resultSet) {
            if (target.isCancelled()) {
                return;
            }
            try {
                this.collectPage(resultSet.currentPage());
            }
            catch (RuntimeException e) {
                target.completeExceptionally(e);
                return;
            }
            if (!resultSet.hasMorePages()) {
                target.complete(this.finish());
            } else {
                CompletionStage nextPage = resultSet.fetchNextPage();
                nextPage.whenComplete((nextResultSet, throwable) -> {
                    if (throwable != null) {
                        target.completeExceptionally((Throwable)throwable);
                    } else {
                        this.collectAsync(target, (AsyncResultSet)nextResultSet);
                    }
                });
            }
        }
    }

    class ForwardLoopState {
        private final AtomicInteger rowNumber = new AtomicInteger();
        private final Consumer<T> consumer;

        ForwardLoopState(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        void peekRow(Iterable<Row> rows) {
            rows.forEach(row -> this.consumer.accept(AsyncResultStream.this.mapper.mapRow((Row)row, this.rowNumber.incrementAndGet())));
        }

        void forEachAsync(CompletableFuture<Void> target, AsyncResultSet resultSet) {
            if (target.isCancelled()) {
                return;
            }
            try {
                this.peekRow(resultSet.currentPage());
            }
            catch (RuntimeException e) {
                target.completeExceptionally(e);
                return;
            }
            if (!resultSet.hasMorePages()) {
                target.complete(null);
            } else {
                CompletionStage nextPage = resultSet.fetchNextPage();
                nextPage.whenComplete((nextResultSet, throwable) -> {
                    if (throwable != null) {
                        target.completeExceptionally((Throwable)throwable);
                    } else {
                        this.forEachAsync(target, (AsyncResultSet)nextResultSet);
                    }
                });
            }
        }
    }
}

