/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.List;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.core.ExecutableSelectOperation;
import org.springframework.data.cassandra.core.QueryOperations;
import org.springframework.data.cassandra.core.QueryResultConverter;
import org.springframework.data.cassandra.core.cql.QueryExtractorDelegate;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.domain.Slice;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class ExecutableSelectOperationSupport
implements ExecutableSelectOperation {
    private final CassandraTemplate template;
    private final QueryOperations queryOperations;

    public ExecutableSelectOperationSupport(CassandraTemplate template, QueryOperations queryOperations) {
        this.template = template;
        this.queryOperations = queryOperations;
    }

    @Override
    public <T> ExecutableSelectOperation.ExecutableSelect<T> query(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ExecutableSelectSupport(domainType, domainType, QueryResultConverter.entity(), Query.empty(), null);
    }

    @Override
    public ExecutableSelectOperation.UntypedSelect query(String cql) {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        return new UntypedSelectSupport((Statement<?>)SimpleStatement.newInstance((String)cql));
    }

    @Override
    public ExecutableSelectOperation.UntypedSelect query(Statement<?> statement) {
        Assert.notNull(statement, (String)"Statement must not be null");
        return new UntypedSelectSupport(statement);
    }

    class ExecutableSelectSupport<S, T>
    implements ExecutableSelectOperation.ExecutableSelect<T> {
        private final Class<?> domainType;
        private final Class<S> returnType;
        private final QueryResultConverter<? super S, ? extends T> mappingFunction;
        private final Query query;
        private final @Nullable CqlIdentifier tableName;

        public ExecutableSelectSupport(Class<?> domainType, Class<S> returnType, QueryResultConverter<? super S, ? extends T> mappingFunction, @Nullable Query query2, CqlIdentifier tableName) {
            this.domainType = domainType;
            this.returnType = returnType;
            this.mappingFunction = mappingFunction;
            this.query = query2;
            this.tableName = tableName;
        }

        @Override
        public <R> ExecutableSelectOperation.TerminatingResults<R> map(QueryResultConverter<? super T, ? extends R> converter) {
            Assert.notNull(converter, (String)"Mapping function name must not be null");
            return new ExecutableSelectSupport<S, R>(this.domainType, this.returnType, this.mappingFunction.andThen(converter), this.query, this.tableName);
        }

        @Override
        public ExecutableSelectOperation.SelectWithProjection<T> inTable(CqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ExecutableSelectSupport<S, T>(this.domainType, this.returnType, this.mappingFunction, this.query, tableName);
        }

        @Override
        public <R> ExecutableSelectOperation.SelectWithQuery<R> as(Class<R> returnType) {
            Assert.notNull(returnType, (String)"ReturnType must not be null");
            return new ExecutableSelectSupport(this.domainType, returnType, QueryResultConverter.entity(), this.query, this.tableName);
        }

        @Override
        public ExecutableSelectOperation.TerminatingSelect<T> matching(Query query2) {
            Assert.notNull((Object)query2, (String)"Query must not be null");
            return new ExecutableSelectSupport<S, T>(this.domainType, this.returnType, this.mappingFunction, query2, this.tableName);
        }

        @Override
        public long count() {
            return ExecutableSelectOperationSupport.this.template.doCount(this.query, this.domainType, this.getTableName());
        }

        @Override
        public boolean exists() {
            return ExecutableSelectOperationSupport.this.template.doExists(this.query, this.domainType, this.getTableName());
        }

        @Override
        public @Nullable T firstValue() {
            List result = this.prepare(this.query.limit(1L)).select(ExecutableSelectOperationSupport.this.template::doQuery);
            return ObjectUtils.isEmpty((Object)result) ? null : (T)result.iterator().next();
        }

        @Override
        public @Nullable T oneValue() {
            if (this.returnType.equals(ResultSet.class)) {
                return (T)ExecutableSelectOperationSupport.this.template.doSelectResultSet(this.query.limit(2L), this.domainType, this.getTableName());
            }
            List result = this.prepare(this.query.limit(2L)).select(ExecutableSelectOperationSupport.this.template::doQuery);
            if (ObjectUtils.isEmpty((Object)result)) {
                return null;
            }
            if (result.size() > 1) {
                throw new IncorrectResultSizeDataAccessException(1, result.size());
            }
            return (T)result.iterator().next();
        }

        @Override
        public List<T> all() {
            return this.prepare(this.query).select(ExecutableSelectOperationSupport.this.template::doQuery);
        }

        @Override
        public Slice<T> slice() {
            return this.prepare(this.query).select(ExecutableSelectOperationSupport.this.template::doSlice);
        }

        @Override
        public Stream<T> stream() {
            return this.prepare(this.query).select(ExecutableSelectOperationSupport.this.template::doStream);
        }

        public QueryOperations.TerminalSelect<T> prepare(Query query2) {
            return ExecutableSelectOperationSupport.this.queryOperations.select(this.domainType, this.getTableName()).project(this.returnType, this.mappingFunction).matching(query2);
        }

        private CqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : ExecutableSelectOperationSupport.this.template.getTableName(this.domainType);
        }
    }

    class UntypedSelectSupport
    implements ExecutableSelectOperation.UntypedSelect {
        private final Statement<?> statement;

        private UntypedSelectSupport(Statement<?> statement) {
            this.statement = statement;
        }

        @Override
        public <T> ExecutableSelectOperation.TerminatingResults<T> as(Class<T> resultType) {
            Assert.notNull(resultType, (String)"Result type must not be null");
            return new TypedSelectSupport<T>(this.statement, resultType);
        }

        @Override
        public <T> ExecutableSelectOperation.TerminatingResults<T> map(RowMapper<T> mapper) {
            Assert.notNull(mapper, (String)"RowMapper must not be null");
            return new TerminatingSelectResultSupport(this.statement, mapper);
        }

        @Override
        public long count() {
            List<Row> rows = ExecutableSelectOperationSupport.this.template.select(this.statement, Row.class);
            if (rows.size() == 1) {
                Object object = rows.get(0).getObject(0);
                return ((Number)object).longValue();
            }
            return 0L;
        }
    }

    class TerminatingSelectResultSupport<S, T>
    implements ExecutableSelectOperation.TerminatingResults<T> {
        final Statement<?> statement;
        final @Nullable RowMapper<T> rowMapper;

        TerminatingSelectResultSupport(@Nullable Statement<?> statement, RowMapper<T> rowMapper) {
            this.statement = statement;
            this.rowMapper = rowMapper;
        }

        TerminatingSelectResultSupport(Statement<?> statement, Class<S> domainType, QueryResultConverter<? super S, ? extends T> mappingFunction) {
            this(statement, this$0.queryOperations.getRowMapper(domainType, statement, mappingFunction));
        }

        @Override
        public <R> ExecutableSelectOperation.TerminatingResults<R> map(QueryResultConverter<? super T, ? extends R> converter) {
            return new TerminatingSelectResultSupport<S, Object>(this.statement, (row, rowNum) -> converter.mapRow(row, () -> this.rowMapper.mapRow(row, rowNum)));
        }

        @Override
        public @Nullable T firstValue() {
            List<T> result = ExecutableSelectOperationSupport.this.template.getCqlOperations().query(this.statement, this.rowMapper);
            return ObjectUtils.isEmpty(result) ? null : (T)result.iterator().next();
        }

        @Override
        public @Nullable T oneValue() {
            if (this.rowMapper == null) {
                return (T)ExecutableSelectOperationSupport.this.template.queryForResultSet(this.statement);
            }
            List<T> result = ExecutableSelectOperationSupport.this.template.getCqlOperations().query(this.statement, this.rowMapper);
            if (ObjectUtils.isEmpty(result)) {
                return null;
            }
            if (result.size() > 1) {
                throw new IncorrectResultSizeDataAccessException(String.format("Query [%s] returned non unique result", QueryExtractorDelegate.getCql(this.statement)), 1);
            }
            return result.iterator().next();
        }

        @Override
        public List<T> all() {
            return ExecutableSelectOperationSupport.this.template.getCqlOperations().query(this.statement, this.rowMapper);
        }

        @Override
        public Slice<T> slice() {
            return ExecutableSelectOperationSupport.this.template.doSlice(this.statement, this.rowMapper);
        }

        @Override
        public Stream<T> stream() {
            return ExecutableSelectOperationSupport.this.template.getCqlOperations().queryForStream(this.statement, this.rowMapper);
        }
    }

    class TypedSelectSupport<T>
    extends TerminatingSelectResultSupport<T, T>
    implements ExecutableSelectOperation.TerminatingResults<T> {
        private final Class<T> domainType;

        TypedSelectSupport(Statement<?> statement, Class<T> domainType) {
            super(statement, ResultSet.class.isAssignableFrom(domainType) ? null : ExecutableSelectOperationSupport.this.queryOperations.getRowMapper(domainType, statement));
            this.domainType = domainType;
        }

        @Override
        public <R> ExecutableSelectOperation.TerminatingResults<R> map(QueryResultConverter<? super T, ? extends R> converter) {
            Assert.notNull(converter, (String)"Mapping function must not be null");
            return new TerminatingSelectResultSupport<T, R>(this.statement, this.domainType, converter);
        }
    }
}

