/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.query;

import com.datastax.oss.driver.api.core.data.CqlVector;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Vector;
import org.springframework.util.Assert;

public class VectorSort
extends Sort {
    private static final long serialVersionUID = 1L;
    private final Object vector;

    public VectorSort(String column, Object vector) {
        super(List.of(Sort.Order.by((String)column)));
        this.vector = vector;
    }

    public VectorSort(List<Sort.Order> orders, Object vector) {
        super(orders);
        Assert.isTrue((orders.size() == 1 ? 1 : 0) != 0, (String)"Orders must contain a single element");
        this.vector = vector;
    }

    public static VectorSort ann(String column, CqlVector<? extends Number> vector) {
        return new VectorSort(column, vector);
    }

    public static VectorSort ann(String column, float ... vector) {
        return new VectorSort(column, (Object)Vector.of((float[])vector));
    }

    public static VectorSort ann(String column, double ... vector) {
        return new VectorSort(column, (Object)Vector.of((double[])vector));
    }

    public static VectorSort ann(String column, Vector vector) {
        return new VectorSort(column, (Object)vector);
    }

    public Object getVector() {
        return this.vector;
    }
}

