/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.lang.Contract;
import org.springframework.util.ObjectUtils;

public class QueryExtractorDelegate {
    static String getCql(CqlProvider statement) {
        return statement.getCql();
    }

    static String getCql(SimpleStatement statement) {
        return statement.getQuery();
    }

    static String getCql(PreparedStatement statement) {
        return statement.getQuery();
    }

    static String getCql(BoundStatement statement) {
        return QueryExtractorDelegate.getCql(statement.getPreparedStatement());
    }

    static String getCql(BatchStatement statement) {
        StringBuilder builder = new StringBuilder();
        for (BatchableStatement batchableStatement : statement) {
            String query2 = QueryExtractorDelegate.getCql(batchableStatement);
            builder.append(query2);
            if (ObjectUtils.isEmpty((Object)query2)) continue;
            builder.append(query2.endsWith(";") ? "" : ";");
        }
        return builder.toString();
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable String getCql(@Nullable Object statement) {
        if (statement == null) {
            return null;
        }
        if (statement instanceof CqlProvider) {
            CqlProvider cp = (CqlProvider)statement;
            return QueryExtractorDelegate.getCql(cp);
        }
        if (statement instanceof SimpleStatement) {
            SimpleStatement st = (SimpleStatement)statement;
            return QueryExtractorDelegate.getCql(st);
        }
        if (statement instanceof PreparedStatement) {
            PreparedStatement pst = (PreparedStatement)statement;
            return QueryExtractorDelegate.getCql(pst);
        }
        if (statement instanceof BoundStatement) {
            BoundStatement bst = (BoundStatement)statement;
            return QueryExtractorDelegate.getCql(bst);
        }
        if (statement instanceof BatchStatement) {
            BatchStatement bst = (BatchStatement)statement;
            return QueryExtractorDelegate.getCql(bst);
        }
        return "Unknown: " + String.valueOf(statement);
    }
}

