/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public interface ReactiveInsertOperation {
    public <T> ReactiveInsert<T> insert(Class<T> var1);

    public static interface ReactiveInsert<T>
    extends InsertWithTable<T> {
    }

    public static interface TerminatingInsert<T> {
        public Mono<EntityWriteResult<T>> one(T var1);
    }

    public static interface InsertWithOptions<T>
    extends TerminatingInsert<T> {
        @Contract(value="_ -> new")
        public TerminatingInsert<T> withOptions(InsertOptions var1);
    }

    public static interface InsertWithTable<T>
    extends InsertWithOptions<T> {
        @Contract(value="_ -> new")
        default public InsertWithOptions<T> inTable(String table) {
            Assert.hasText((String)table, (String)"Table must not be null or empty");
            return this.inTable(CqlIdentifier.fromCql((String)table));
        }

        @Contract(value="_ -> new")
        public InsertWithOptions<T> inTable(CqlIdentifier var1);
    }
}

