/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.query.CassandraEntityInformation;
import org.springframework.data.cassandra.repository.query.ReactiveCassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.ReactivePartTreeCassandraQuery;
import org.springframework.data.cassandra.repository.query.ReactiveStringBasedCassandraQuery;
import org.springframework.data.cassandra.repository.support.MappingCassandraEntityInformation;
import org.springframework.data.cassandra.repository.support.ReactiveCassandraRepositoryFragmentsContributor;
import org.springframework.data.cassandra.repository.support.SimpleReactiveCassandraRepository;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.ReactiveRepositoryFactorySupport;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.query.CachingValueExpressionDelegate;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.util.Assert;

public class ReactiveCassandraRepositoryFactory
extends ReactiveRepositoryFactorySupport {
    private final ReactiveCassandraOperations operations;
    private final MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty> mappingContext;
    private ReactiveCassandraRepositoryFragmentsContributor fragmentsContributor = ReactiveCassandraRepositoryFragmentsContributor.DEFAULT;

    public ReactiveCassandraRepositoryFactory(ReactiveCassandraOperations cassandraOperations) {
        Assert.notNull((Object)cassandraOperations, (String)"ReactiveCassandraOperations must not be null");
        this.operations = cassandraOperations;
        this.mappingContext = cassandraOperations.getConverter().getMappingContext();
    }

    public void setFragmentsContributor(ReactiveCassandraRepositoryFragmentsContributor fragmentsContributor) {
        this.fragmentsContributor = fragmentsContributor;
    }

    protected ProjectionFactory getProjectionFactory(@Nullable ClassLoader classLoader, @Nullable BeanFactory beanFactory) {
        return this.operations.getConverter().getProjectionFactory();
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleReactiveCassandraRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        EntityInformation entityInformation = this.getEntityInformation((RepositoryMetadata)information);
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.operations});
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable QueryLookupStrategy.Key key, ValueExpressionDelegate valueExpressionDelegate) {
        return Optional.of(new CassandraQueryLookupStrategy(this.operations, (ValueExpressionDelegate)new CachingValueExpressionDelegate(valueExpressionDelegate), this.mappingContext));
    }

    public CassandraEntityInformation<?, ?> getEntityInformation(RepositoryMetadata metadata) {
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(metadata.getDomainType());
        return new MappingCassandraEntityInformation(entity, this.operations.getConverter());
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        return this.getRepositoryFragments(metadata, this.operations);
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata, ReactiveCassandraOperations operations) {
        return this.fragmentsContributor.contribute(metadata, (CassandraEntityInformation<?, ?>)this.getEntityInformation(metadata), operations);
    }

    private record CassandraQueryLookupStrategy(ReactiveCassandraOperations operations, ValueExpressionDelegate delegate, MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty> mappingContext) implements QueryLookupStrategy
    {
        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            ReactiveCassandraQueryMethod queryMethod = new ReactiveCassandraQueryMethod(method, metadata, factory, this.mappingContext);
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new ReactiveStringBasedCassandraQuery(namedQuery, queryMethod, this.operations, this.delegate);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new ReactiveStringBasedCassandraQuery(queryMethod, this.operations, this.delegate);
            }
            return new ReactivePartTreeCassandraQuery(queryMethod, this.operations);
        }
    }
}

