/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.cql.ExecutionProfileResolver;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class QueryOptions {
    private static final QueryOptions EMPTY = QueryOptions.builder().build();
    private final @Nullable ConsistencyLevel consistencyLevel;
    private final ExecutionProfileResolver executionProfileResolver;
    private final @Nullable Boolean idempotent;
    private final @Nullable CqlIdentifier keyspace;
    private final @Nullable Integer pageSize;
    private final @Nullable CqlIdentifier routingKeyspace;
    private final @Nullable ByteBuffer routingKey;
    private final @Nullable ConsistencyLevel serialConsistencyLevel;
    private final Duration timeout;
    private final @Nullable Boolean tracing;

    protected QueryOptions(@Nullable ConsistencyLevel consistencyLevel, ExecutionProfileResolver executionProfileResolver, @Nullable Boolean idempotent, @Nullable CqlIdentifier keyspace, @Nullable Integer pageSize, @Nullable CqlIdentifier routingKeyspace, @Nullable ByteBuffer routingKey, @Nullable ConsistencyLevel serialConsistencyLevel, Duration timeout, @Nullable Boolean tracing) {
        this.consistencyLevel = consistencyLevel;
        this.executionProfileResolver = executionProfileResolver;
        this.idempotent = idempotent;
        this.keyspace = keyspace;
        this.pageSize = pageSize;
        this.routingKey = routingKey;
        this.routingKeyspace = routingKeyspace;
        this.serialConsistencyLevel = serialConsistencyLevel;
        this.timeout = timeout;
        this.tracing = tracing;
    }

    public static QueryOptionsBuilder builder() {
        return new QueryOptionsBuilder();
    }

    public static QueryOptions empty() {
        return EMPTY;
    }

    public QueryOptionsBuilder mutate() {
        return new QueryOptionsBuilder(this);
    }

    protected @Nullable ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    protected ExecutionProfileResolver getExecutionProfileResolver() {
        return this.executionProfileResolver;
    }

    protected @Nullable Boolean isIdempotent() {
        return this.idempotent;
    }

    public @Nullable CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    protected @Nullable Integer getPageSize() {
        return this.pageSize;
    }

    @Deprecated
    protected Duration getReadTimeout() {
        return this.getTimeout();
    }

    protected @Nullable CqlIdentifier getRoutingKeyspace() {
        return this.routingKeyspace;
    }

    protected @Nullable ByteBuffer getRoutingKey() {
        return this.routingKey;
    }

    protected Duration getTimeout() {
        return this.timeout;
    }

    protected @Nullable ConsistencyLevel getSerialConsistencyLevel() {
        return this.serialConsistencyLevel;
    }

    protected @Nullable Boolean getTracing() {
        return this.tracing;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryOptions)) {
            return false;
        }
        QueryOptions options = (QueryOptions)o;
        if (!ObjectUtils.nullSafeEquals((Object)this.consistencyLevel, (Object)options.consistencyLevel)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.executionProfileResolver, (Object)options.executionProfileResolver)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.idempotent, (Object)options.idempotent)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.pageSize, (Object)options.pageSize)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.routingKeyspace, (Object)options.routingKeyspace)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.routingKey, (Object)options.routingKey)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.serialConsistencyLevel, (Object)options.serialConsistencyLevel)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.timeout, (Object)options.timeout)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.tracing, (Object)options.tracing)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.keyspace, (Object)options.keyspace);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.consistencyLevel);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.executionProfileResolver);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.idempotent);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.keyspace);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.pageSize);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.routingKeyspace);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.routingKey);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.serialConsistencyLevel);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.timeout);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.tracing);
        return result;
    }

    public static class QueryOptionsBuilder {
        protected @Nullable ConsistencyLevel consistencyLevel;
        protected ExecutionProfileResolver executionProfileResolver = ExecutionProfileResolver.none();
        protected @Nullable Boolean idempotent;
        protected @Nullable CqlIdentifier keyspace;
        protected @Nullable ByteBuffer routingKey;
        protected @Nullable CqlIdentifier routingKeyspace;
        protected @Nullable Integer pageSize;
        protected @Nullable ConsistencyLevel serialConsistencyLevel;
        protected Duration timeout = Duration.ofMillis(-1L);
        protected @Nullable Boolean tracing;

        QueryOptionsBuilder() {
        }

        QueryOptionsBuilder(QueryOptions queryOptions) {
            this.consistencyLevel = queryOptions.consistencyLevel;
            this.executionProfileResolver = queryOptions.executionProfileResolver;
            this.idempotent = queryOptions.idempotent;
            this.keyspace = queryOptions.keyspace;
            this.pageSize = queryOptions.pageSize;
            this.routingKey = queryOptions.routingKey;
            this.routingKeyspace = queryOptions.routingKeyspace;
            this.serialConsistencyLevel = queryOptions.serialConsistencyLevel;
            this.timeout = queryOptions.timeout;
            this.tracing = queryOptions.tracing;
        }

        public QueryOptionsBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            Assert.notNull((Object)consistencyLevel, (String)"ConsistencyLevel must not be null");
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public QueryOptionsBuilder executionProfile(String profileName) {
            return this.executionProfile(ExecutionProfileResolver.from(profileName));
        }

        public QueryOptionsBuilder executionProfile(ExecutionProfileResolver executionProfileResolver) {
            Assert.notNull((Object)executionProfileResolver, (String)"ExecutionProfileResolver must not be null");
            this.executionProfileResolver = executionProfileResolver;
            return this;
        }

        @Deprecated
        public QueryOptionsBuilder fetchSize(int fetchSize) {
            return this.pageSize(fetchSize);
        }

        public QueryOptionsBuilder idempotent(boolean idempotent) {
            this.idempotent = idempotent;
            return this;
        }

        public QueryOptionsBuilder keyspace(CqlIdentifier keyspace) {
            Assert.notNull((Object)keyspace, (String)"Keyspace must not be null");
            this.keyspace = keyspace;
            return this;
        }

        public QueryOptionsBuilder pageSize(int pageSize) {
            Assert.isTrue((pageSize >= 0 ? 1 : 0) != 0, (String)"Page size must be greater than equal to zero");
            this.pageSize = pageSize;
            return this;
        }

        @Deprecated
        public QueryOptionsBuilder readTimeout(long readTimeout) {
            return this.timeout(Duration.ofMillis(readTimeout));
        }

        @Deprecated
        public QueryOptionsBuilder readTimeout(long readTimeout, TimeUnit timeUnit) {
            Assert.isTrue((readTimeout >= 0L ? 1 : 0) != 0, (String)"ReadTimeout must be greater than equal to zero");
            Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit must not be null");
            return this.timeout(Duration.ofMillis(timeUnit.toMillis(readTimeout)));
        }

        @Deprecated
        public QueryOptionsBuilder readTimeout(Duration readTimeout) {
            return this.timeout(readTimeout);
        }

        public QueryOptionsBuilder routingKeyspace(CqlIdentifier routingKeyspace) {
            Assert.notNull((Object)routingKeyspace, (String)"Routing keyspace must not be null");
            this.routingKeyspace = routingKeyspace;
            return this;
        }

        public QueryOptionsBuilder routingKey(ByteBuffer routingKey) {
            Assert.notNull((Object)routingKey, (String)"Routing key must not be null");
            this.routingKey = routingKey;
            return this;
        }

        public QueryOptionsBuilder serialConsistencyLevel(ConsistencyLevel consistencyLevel) {
            Assert.notNull((Object)consistencyLevel, (String)"Serial ConsistencyLevel must not be null");
            this.serialConsistencyLevel = consistencyLevel;
            return this;
        }

        public QueryOptionsBuilder timeout(Duration timeout) {
            Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"ReadTimeout must be greater than equal to zero");
            this.timeout = timeout;
            return this;
        }

        public QueryOptionsBuilder tracing(boolean tracing) {
            this.tracing = tracing;
            return this;
        }

        public QueryOptionsBuilder withTracing() {
            return this.tracing(true);
        }

        public QueryOptions build() {
            return new QueryOptions(this.consistencyLevel, this.executionProfileResolver, this.idempotent, this.keyspace, this.pageSize, this.routingKeyspace, this.routingKey, this.serialConsistencyLevel, this.timeout, this.tracing);
        }
    }
}

