/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.ReactiveCassandraTemplate;
import org.springframework.data.cassandra.core.ReactiveDeleteOperation;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

class ReactiveDeleteOperationSupport
implements ReactiveDeleteOperation {
    private final ReactiveCassandraTemplate template;

    public ReactiveDeleteOperationSupport(ReactiveCassandraTemplate template) {
        this.template = template;
    }

    @Override
    public ReactiveDeleteOperation.ReactiveDelete delete(Class<?> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ReactiveDeleteSupport(this.template, domainType, Query.empty(), null);
    }

    static class ReactiveDeleteSupport
    implements ReactiveDeleteOperation.ReactiveDelete,
    ReactiveDeleteOperation.TerminatingDelete {
        private final ReactiveCassandraTemplate template;
        private final Class<?> domainType;
        private final Query query;
        private final @Nullable CqlIdentifier tableName;

        public ReactiveDeleteSupport(ReactiveCassandraTemplate template, Class<?> domainType, Query query2, @Nullable CqlIdentifier tableName) {
            this.template = template;
            this.domainType = domainType;
            this.query = query2;
            this.tableName = tableName;
        }

        @Override
        public ReactiveDeleteOperation.DeleteWithQuery inTable(CqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ReactiveDeleteSupport(this.template, this.domainType, this.query, tableName);
        }

        @Override
        public ReactiveDeleteOperation.TerminatingDelete matching(Query query2) {
            Assert.notNull((Object)query2, (String)"Query must not be null");
            return new ReactiveDeleteSupport(this.template, this.domainType, query2, this.tableName);
        }

        @Override
        public Mono<WriteResult> all() {
            return this.template.doDelete(this.query, this.domainType, this.getTableName());
        }

        private CqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }
    }
}

