/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Locale;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.Consistency;
import org.springframework.data.cassandra.repository.Query;
import org.springframework.data.cassandra.repository.query.CassandraEntityMetadata;
import org.springframework.data.cassandra.repository.query.CassandraParameters;
import org.springframework.data.cassandra.repository.query.SimpleCassandraEntityMetadata;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CassandraQueryMethod
extends QueryMethod {
    private final Method method;
    private final MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty> mappingContext;
    private final @Nullable Query query;
    private final @Nullable Consistency consistency;
    private @Nullable CassandraEntityMetadata<?> entityMetadata;

    public CassandraQueryMethod(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty> mappingContext) {
        super(method, repositoryMetadata, projectionFactory, CassandraParameters::new);
        Assert.notNull(mappingContext, (String)"MappingContext must not be null");
        this.verify(method, repositoryMetadata);
        this.method = method;
        this.mappingContext = mappingContext;
        this.query = (Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Query.class);
        this.consistency = (Consistency)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Consistency.class);
    }

    public void verify(Method method, RepositoryMetadata metadata) {
        if (this.isPageQuery()) {
            throw new InvalidDataAccessApiUsageException("Page queries are not supported; Use a Slice query");
        }
    }

    public CassandraEntityMetadata<?> getEntityInformation() {
        if (this.entityMetadata == null) {
            Class returnedObjectType = this.getReturnedObjectType();
            Class<?> domainClass = this.getDomainClass();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedObjectType)) {
                this.entityMetadata = new SimpleCassandraEntityMetadata(domainClass, (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass));
            } else {
                CassandraPersistentEntity returnedEntity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(returnedObjectType);
                CassandraPersistentEntity managedEntity = (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
                returnedEntity = returnedEntity == null || returnedEntity.getType().isInterface() ? managedEntity : returnedEntity;
                this.entityMetadata = new SimpleCassandraEntityMetadata(returnedEntity.getType(), managedEntity);
            }
        }
        return this.entityMetadata;
    }

    public CassandraParameters getParameters() {
        return (CassandraParameters)super.getParameters();
    }

    public boolean hasAnnotatedQuery() {
        return this.query != null && StringUtils.hasText((String)this.query.value());
    }

    public @Nullable String getAnnotatedQuery() {
        return this.query != null ? this.query.value() : null;
    }

    public boolean hasConsistencyLevel() {
        return this.consistency != null;
    }

    public ConsistencyLevel getRequiredAnnotatedConsistencyLevel() throws IllegalStateException {
        if (this.consistency == null) {
            throw new IllegalStateException("No @Consistency annotation found");
        }
        return this.consistency.value();
    }

    public String getRequiredAnnotatedQuery() {
        if (this.query == null) {
            throw new IllegalStateException("Query method " + this + " has no annotated query");
        }
        return this.query.value();
    }

    @Nullable Query getQueryAnnotation() {
        return this.query;
    }

    Query getRequiredQueryAnnotation() {
        Query query2 = this.getQueryAnnotation();
        if (query2 == null) {
            throw new IllegalStateException("No @Consistency annotation found");
        }
        return query2;
    }

    protected Class<?> getDomainClass() {
        return super.getDomainClass();
    }

    public TypeInformation<?> getReturnType() {
        return TypeInformation.fromReturnTypeOf((Method)this.method);
    }

    public boolean isResultSetQuery() {
        TypeInformation actualType = this.getReturnType().getActualType();
        return actualType != null && ResultSet.class.isAssignableFrom(actualType.getType());
    }

    Query.Idempotency getIdempotency() {
        if (this.query == null) {
            return Query.Idempotency.UNDEFINED;
        }
        if (this.query.idempotent() != Query.Idempotency.UNDEFINED) {
            return this.query.idempotent();
        }
        String cql = this.getAnnotatedQuery();
        if (StringUtils.hasText((String)cql) && cql.trim().toUpperCase(Locale.ENGLISH).startsWith("SELECT ")) {
            return Query.Idempotency.IDEMPOTENT;
        }
        return Query.Idempotency.UNDEFINED;
    }
}

