/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.data.CqlVector;
import java.net.InetAddress;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.data.cassandra.core.convert.CassandraVector;
import org.springframework.data.cassandra.core.cql.converter.RowToListConverter;
import org.springframework.data.cassandra.core.cql.converter.RowToMapConverter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.domain.Vector;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;

public abstract class CassandraConverters {
    private CassandraConverters() {
    }

    static Collection<Object> getConvertersToRegister() {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.add((Object)RowToCassandraLocalDateConverter.INSTANCE);
        converters.add((Object)RowToBooleanConverter.INSTANCE);
        converters.add((Object)RowToInstantConverter.INSTANCE);
        converters.add((Object)RowToDateConverter.INSTANCE);
        converters.add((Object)RowToInetAddressConverter.INSTANCE);
        converters.add((Object)RowToListConverter.INSTANCE);
        converters.add((Object)RowToMapConverter.INSTANCE);
        converters.add((Object)RowToNumberConverterFactory.INSTANCE);
        converters.add((Object)RowToStringConverter.INSTANCE);
        converters.add((Object)RowToUuidConverter.INSTANCE);
        converters.add((Object)VectorToFloatArrayConverter.INSTANCE);
        converters.add((Object)VectorToDoubleArrayConverter.INSTANCE);
        converters.add((Object)VectorToFloatListConverter.INSTANCE);
        converters.add((Object)FloatArrayToVectorConverter.INSTANCE);
        converters.add((Object)DoubleArrayToVectorConverter.INSTANCE);
        converters.add((Object)NumberListToVectorConverter.INSTANCE);
        converters.add((Object)VectorToCqlVectorConverter.INSTANCE);
        converters.add((Object)CqlVectorToVectorConverter.INSTANCE);
        return converters;
    }

    @ReadingConverter
    public static enum RowToCassandraLocalDateConverter implements Converter<Row, LocalDate>
    {
        INSTANCE;


        public @Nullable LocalDate convert(Row row) {
            return row.getLocalDate(0);
        }
    }

    @ReadingConverter
    public static enum RowToBooleanConverter implements Converter<Row, Boolean>
    {
        INSTANCE;


        public Boolean convert(Row row) {
            return row.getBoolean(0);
        }
    }

    @ReadingConverter
    public static enum RowToInstantConverter implements Converter<Row, Instant>
    {
        INSTANCE;


        public @Nullable Instant convert(Row row) {
            return row.getInstant(0);
        }
    }

    @ReadingConverter
    public static enum RowToDateConverter implements Converter<Row, Date>
    {
        INSTANCE;


        public @Nullable Date convert(Row row) {
            Instant instant = row.getInstant(0);
            return instant != null ? Date.from(instant) : null;
        }
    }

    @ReadingConverter
    public static enum RowToInetAddressConverter implements Converter<Row, InetAddress>
    {
        INSTANCE;


        public @Nullable InetAddress convert(Row row) {
            return row.getInetAddress(0);
        }
    }

    @ReadingConverter
    public static enum RowToNumberConverterFactory implements ConverterFactory<Row, Number>
    {
        INSTANCE;


        public <T extends Number> Converter<Row, T> getConverter(Class<T> targetType) {
            Assert.notNull(targetType, (String)"Target type must not be null");
            return new RowToNumber<T>(targetType);
        }

        private static final class RowToNumber<T extends Number>
        implements Converter<Row, T> {
            private final Class<T> targetType;

            RowToNumber(Class<T> targetType) {
                this.targetType = targetType;
            }

            public @Nullable T convert(Row source) {
                Object object = source.getObject(0);
                return (T)(object != null ? (Number)NumberUtils.convertNumberToTargetClass((Number)((Number)object), this.targetType) : (Number)null);
            }
        }
    }

    @ReadingConverter
    public static enum RowToStringConverter implements Converter<Row, String>
    {
        INSTANCE;


        public @Nullable String convert(Row row) {
            return row.getString(0);
        }
    }

    @ReadingConverter
    public static enum RowToUuidConverter implements Converter<Row, UUID>
    {
        INSTANCE;


        public @Nullable UUID convert(Row row) {
            return row.getUuid(0);
        }
    }

    @ReadingConverter
    public static enum VectorToFloatArrayConverter implements Converter<CqlVector<Number>, float[]>
    {
        INSTANCE;


        public float[] convert(CqlVector<Number> source) {
            float[] array = new float[source.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((Number)source.get(i)).floatValue();
            }
            return array;
        }
    }

    @ReadingConverter
    public static enum VectorToDoubleArrayConverter implements Converter<CqlVector<Number>, double[]>
    {
        INSTANCE;


        public double[] convert(CqlVector<Number> source) {
            double[] array = new double[source.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((Number)source.get(i)).doubleValue();
            }
            return array;
        }
    }

    @ReadingConverter
    public static enum VectorToFloatListConverter implements Converter<CqlVector<Number>, List<Float>>
    {
        INSTANCE;


        public List<Float> convert(CqlVector<Number> source) {
            ArrayList<Float> values = new ArrayList<Float>(source.size());
            for (int i = 0; i < source.size(); ++i) {
                values.add(Float.valueOf(((Number)source.get(i)).floatValue()));
            }
            return values;
        }
    }

    @ReadingConverter
    public static enum FloatArrayToVectorConverter implements Converter<float[], CqlVector<Float>>
    {
        INSTANCE;


        public CqlVector<Float> convert(float[] source) {
            Object[] converted = new Float[source.length];
            for (int i = 0; i < converted.length; ++i) {
                converted[i] = Float.valueOf(source[i]);
            }
            return CqlVector.newInstance((Object[])converted);
        }
    }

    @ReadingConverter
    public static enum DoubleArrayToVectorConverter implements Converter<double[], CqlVector<Double>>
    {
        INSTANCE;


        public CqlVector<Double> convert(double[] source) {
            Object[] converted = new Double[source.length];
            for (int i = 0; i < converted.length; ++i) {
                converted[i] = source[i];
            }
            return CqlVector.newInstance((Object[])converted);
        }
    }

    @ReadingConverter
    public static enum NumberListToVectorConverter implements Converter<List<Number>, CqlVector<Number>>
    {
        INSTANCE;


        public CqlVector<Number> convert(List<Number> source) {
            return CqlVector.newInstance(source);
        }
    }

    public static enum VectorToCqlVectorConverter implements Converter<Vector, CqlVector<?>>
    {
        INSTANCE;


        public CqlVector<?> convert(Vector source) {
            if (source instanceof CassandraVector) {
                CassandraVector cv = (CassandraVector)source;
                return cv.getSource();
            }
            if (source.getType() == Float.class || source.getType() == Float.TYPE) {
                float[] floatArray = source.toFloatArray();
                ArrayList<Float> boxed = new ArrayList<Float>(floatArray.length);
                for (float v : floatArray) {
                    boxed.add(Float.valueOf(v));
                }
                return CqlVector.newInstance(boxed);
            }
            return CqlVector.newInstance(Arrays.stream(source.toDoubleArray()).boxed().toList());
        }
    }

    public static enum CqlVectorToVectorConverter implements Converter<CqlVector<?>, Vector>
    {
        INSTANCE;


        public Vector convert(CqlVector<?> source) {
            return CassandraVector.of(source);
        }
    }
}

