/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveSelectOperation {
    public <T> ReactiveSelect<T> query(Class<T> var1);

    public static interface ReactiveSelect<T>
    extends SelectWithTable<T>,
    SelectWithProjection<T> {
    }

    public static interface TerminatingSelect<T> {
        public Mono<Long> count();

        public Mono<Boolean> exists();

        public Mono<T> first();

        public Mono<T> one();

        public Flux<T> all();
    }

    public static interface SelectWithQuery<T>
    extends TerminatingSelect<T> {
        @Contract(value="_ -> new")
        public TerminatingSelect<T> matching(Query var1);
    }

    public static interface SelectWithProjection<T>
    extends SelectWithQuery<T> {
        @Contract(value="_ -> new")
        public <R> SelectWithQuery<R> as(Class<R> var1);
    }

    public static interface SelectWithTable<T>
    extends SelectWithQuery<T> {
        @Contract(value="_ -> new")
        default public SelectWithProjection<T> inTable(String table) {
            Assert.hasText((String)table, (String)"Table name must not be null or empty");
            return this.inTable(CqlIdentifier.fromCql((String)table));
        }

        @Contract(value="_ -> new")
        public SelectWithProjection<T> inTable(CqlIdentifier var1);
    }
}

