/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public interface ExecutableSelectOperation {
    public <T> ExecutableSelect<T> query(Class<T> var1);

    public static interface ExecutableSelect<T>
    extends SelectWithTable<T>,
    SelectWithProjection<T> {
    }

    public static interface TerminatingSelect<T> {
        public long count();

        default public boolean exists() {
            return this.count() > 0L;
        }

        default public Optional<T> first() {
            return Optional.ofNullable(this.firstValue());
        }

        public @Nullable T firstValue();

        default public Optional<T> one() {
            return Optional.ofNullable(this.oneValue());
        }

        public @Nullable T oneValue();

        public List<T> all();

        default public Stream<T> stream() {
            return this.all().stream();
        }
    }

    public static interface SelectWithQuery<T>
    extends TerminatingSelect<T> {
        public TerminatingSelect<T> matching(Query var1);
    }

    public static interface SelectWithProjection<T>
    extends SelectWithQuery<T> {
        @Contract(value="_ -> new")
        public <R> SelectWithQuery<R> as(Class<R> var1);
    }

    public static interface SelectWithTable<T>
    extends SelectWithQuery<T> {
        @Contract(value="_ -> new")
        default public SelectWithProjection<T> inTable(String table) {
            Assert.hasText((String)table, (String)"Table name must not be null or empty");
            return this.inTable(CqlIdentifier.fromCql((String)table));
        }

        @Contract(value="_ -> new")
        public SelectWithProjection<T> inTable(CqlIdentifier var1);
    }
}

