/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.lang.NonNull;

public abstract class CassandraJsr310Converters {
    private CassandraJsr310Converters() {
    }

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        ArrayList converters = new ArrayList();
        converters.add(MillisOfDayToLocalTimeConverter.INSTANCE);
        converters.add(LocalTimeToMillisOfDayConverter.INSTANCE);
        converters.add(DateToInstantConverter.INSTANCE);
        converters.add(InstantToDateConverter.INSTANCE);
        converters.add(LocalDateTimeToInstantConverter.INSTANCE);
        return converters;
    }

    @ReadingConverter
    public static enum MillisOfDayToLocalTimeConverter implements Converter<Long, LocalTime>
    {
        INSTANCE;


        public LocalTime convert(Long source) {
            return LocalTime.ofNanoOfDay(source);
        }
    }

    @ReadingConverter
    public static enum LocalTimeToMillisOfDayConverter implements Converter<LocalTime, Long>
    {
        INSTANCE;


        public Long convert(LocalTime source) {
            return source.getLong(ChronoField.NANO_OF_DAY);
        }
    }

    @WritingConverter
    public static enum DateToInstantConverter implements Converter<Date, Instant>
    {
        INSTANCE;


        public Instant convert(Date source) {
            return source.toInstant();
        }
    }

    @ReadingConverter
    public static enum InstantToDateConverter implements Converter<Instant, Date>
    {
        INSTANCE;


        @NonNull
        public Date convert(Instant source) {
            return Date.from(source);
        }
    }

    @WritingConverter
    static enum LocalDateTimeToInstantConverter implements Converter<LocalDateTime, Instant>
    {
        INSTANCE;


        public Instant convert(LocalDateTime source) {
            return source.atZone(ZoneId.systemDefault()).toInstant();
        }
    }
}

