/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.cassandra.core.mapping.PropertyMapping;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class EntityMapping {
    private Map<String, PropertyMapping> propertyMappings = Collections.emptyMap();
    @Nullable
    private String entityClassName;
    @Deprecated
    private String forceQuote = "false";
    private String tableName = "";

    public EntityMapping(String entityClassName, String tableName) {
        this(entityClassName, tableName, Boolean.FALSE.toString());
    }

    public EntityMapping(String entityClassName, String tableName, String forceQuote) {
        this.setEntityClassName(entityClassName);
        this.setTableName(tableName);
        this.setForceQuote(forceQuote);
    }

    @Nullable
    public String getEntityClassName() {
        return this.entityClassName;
    }

    public void setEntityClassName(String entityClassName) {
        Assert.hasText((String)entityClassName, (String)"Entity class name must not be null or empty");
        this.entityClassName = entityClassName;
    }

    @Deprecated
    public String getForceQuote() {
        return this.forceQuote;
    }

    @Deprecated
    public void setForceQuote(String forceQuote) {
        Assert.notNull((Object)forceQuote, (String)"Force quote must not be null or empty");
        this.forceQuote = forceQuote;
    }

    public Map<String, PropertyMapping> getPropertyMappings() {
        return Collections.unmodifiableMap(this.propertyMappings);
    }

    public void setPropertyMappings(@Nullable Map<String, PropertyMapping> propertyMappings) {
        this.propertyMappings = propertyMappings != null ? new HashMap<String, PropertyMapping>(propertyMappings) : Collections.emptyMap();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        Assert.notNull((Object)tableName, (String)"Table name must not be null or empty");
        this.tableName = tableName;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntityMapping)) {
            return false;
        }
        EntityMapping that = (EntityMapping)obj;
        return ObjectUtils.nullSafeEquals((Object)this.getEntityClassName(), (Object)that.getEntityClassName()) && ObjectUtils.nullSafeEquals((Object)this.getForceQuote(), (Object)that.getForceQuote()) && ObjectUtils.nullSafeEquals((Object)this.getTableName(), (Object)that.getTableName());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getEntityClassName());
        hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getForceQuote());
        hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getTableName());
        return hashValue;
    }

    public String toString() {
        return String.format("{ @type = %1$s, entityClassName = %2$s, tableName = %3$s, forceQuote = %4$s, propertyMappings = %5$s }", this.getClass().getName(), this.getEntityClassName(), this.getTableName(), this.getForceQuote(), this.toString(this.getPropertyMappings()));
    }

    private String toString(Map<?, ?> map) {
        StringBuilder builder = new StringBuilder("[");
        int count = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            builder.append(++count > 1 ? ", " : "");
            builder.append(String.format("%1$s = %2$s", entry.getKey(), entry.getValue()));
        }
        return builder.toString();
    }
}

